(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   4160501,      72160]
NotebookOptionsPosition[   4147258,      71714]
NotebookOutlinePosition[   4147613,      71730]
CellTagsIndexPosition[   4147570,      71727]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Useful Information", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
  3.471719164381555*^9, 3.4717191680331707`*^9}, {3.498485249608289*^9, 
  3.4984852569514637`*^9}, {3.5155246039579363`*^9, 3.515524606395363*^9}, {
  3.552575757317336*^9, 3.552575758981185*^9}}],

Cell[TextData[{
 StyleBox["units\n",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 "mV\npA\nnS\npF\n"
}], "Text",
 CellChangeTimes->{{3.5135120873463907`*^9, 3.513512231081233*^9}, {
   3.51351227856236*^9, 3.513512289197809*^9}, {3.5135123493807917`*^9, 
   3.513512378313299*^9}, 3.513512511238924*^9, {3.517667304310067*^9, 
   3.517667322589411*^9}, {3.517667352934966*^9, 3.5176673532466803`*^9}}],

Cell[TextData[{
 StyleBox["key functions and parameters\n",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 "\nactInfX[v]\t\tsteady-state activation for conductance X (for single \
gating variable)\ninactInfX[v]\t\tsteady-state inactivation for conductance X\
\nactTauX[v]\t\tactivation time constant for conductance X\ninactTauX[v]\t\t\
inactivation time constant for conductance X\n\nvHaX\t\t\thalf activation \
voltage for conductance X\nvSaX\t\t\tactivation slope factor for conductance \
X\nvHiX\t\t\thalf inactivation voltage for conductance X\nvSiX\t\t\t\
inactivation slope factor for conductance X\n\nt1X\t\t\tminimum gating time \
constant of conductance X\nt2X\t\t\tscale parameter for gating time constant \
of conductance X\nvH1X\t\t\tlocation paramerer for voltage dependence of time \
constant (falling phase, if vS1X > 0)\nvS1X\t\t\tslope factor for voltage \
dependence of time constant (falling phase, if  > 0)\nvH2X\t\t\tlocation \
paramerer for voltage dependence of time constant (rising phase, if vS2X < 0)\
\nvS2X\t\t\tslope factor for voltage dependence of time constant (rising \
phase, if < 0)\n\nDistinguish activation from inactivation with \
\[OpenCurlyDoubleQuote]a\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]i\
\[CloseCurlyDoubleQuote] if necessary\nExample: t2aX = scale parameter for \
activation time constant of conductance X. \n\ntempX\t\t\ttemperature at \
which X\[CloseCurlyQuote]s time constant is specified by the above parameters\
\nQ10aX\t\t\tQ10 for conductance X activation kinetics\nQ10iX\t\t\tQ10 for \
conductance X inactivation kinetics\nQ10gX\t\t\tQ10 for total conductance of \
type X\n\nmX\t\t\tactivation gating variable for conductance X\nhX\t\t\t\
inactivation gating variable for conductance X\ngMaxX\t\t\tmaximal X \
conductance\nnX\t\t\tactivation cooperativity for conductance X (conductance \
X  = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["mX", "nX"], " ", "gMaxX"}], TraditionalForm]]],
 ")\n"
}], "Text",
 CellChangeTimes->{{3.5135120873463907`*^9, 3.513512231081233*^9}, {
   3.51351227856236*^9, 3.513512289197809*^9}, {3.5135123493807917`*^9, 
   3.513512378313299*^9}, 3.513512511238924*^9, {3.5155239385934772`*^9, 
   3.515524351808633*^9}, {3.515524429990335*^9, 3.515524585546748*^9}, {
   3.5155246269806347`*^9, 3.5155246298365*^9}, {3.5155246991608267`*^9, 
   3.5155247040401917`*^9}, {3.515524880321686*^9, 3.5155249026001*^9}, {
   3.515525724814559*^9, 3.5155258189271193`*^9}, {3.515525947686605*^9, 
   3.515526002743148*^9}, {3.5155260702077293`*^9, 3.5155261379929733`*^9}, {
   3.515526232922647*^9, 3.515526442161848*^9}, {3.517666985985347*^9, 
   3.51766712431462*^9}, {3.517667163954055*^9, 3.51766718360919*^9}, {
   3.517669451052947*^9, 3.517669459301592*^9}, {3.517831825929422*^9, 
   3.5178318952896843`*^9}, {3.517831954486809*^9, 3.517831973735013*^9}, {
   3.517832068299304*^9, 3.517832132540617*^9}, {3.5178472717729893`*^9, 
   3.51784727228513*^9}}],

Cell[TextData[{
 StyleBox["conductance abbreviations (\[OpenCurlyDoubleQuote]X\
\[CloseCurlyDoubleQuote])\n",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 "\nNa\t\t\tspiking (inactivating) Na\nKdr\t\t\tK delayed rectifier\nA\t\t\t\
rapidly inactivating K\nD\t\t\tslowly inactivating K\nK2\t\t\tvery slowly \
inactivating K\nH\t\t\thyperpolarization-activated cation (HCN)\nT\t\t\t\
inactivating, low threshold Ca"
}], "Text",
 CellChangeTimes->{{3.5135120873463907`*^9, 3.513512231081233*^9}, {
   3.51351227856236*^9, 3.513512289197809*^9}, {3.5135123493807917`*^9, 
   3.513512378313299*^9}, 3.513512511238924*^9, {3.5155239385934772`*^9, 
   3.515524351808633*^9}, {3.515524429990335*^9, 3.515524585546748*^9}, {
   3.5155246269806347`*^9, 3.5155246298365*^9}, {3.5155246991608267`*^9, 
   3.5155247040401917`*^9}, {3.515524880321686*^9, 3.5155249026001*^9}, {
   3.5155250313291273`*^9, 3.515525087560293*^9}, {3.515527310911253*^9, 
   3.515527422251576*^9}, {3.5163587652071543`*^9, 3.516358781429776*^9}, {
   3.517667221410248*^9, 3.517667234513969*^9}, {3.517667385161771*^9, 
   3.517667389192116*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Basic Procedures", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
  3.471719164381555*^9, 3.4717191680331707`*^9}, {3.498485249608289*^9, 
  3.4984852569514637`*^9}, {3.552575873056973*^9, 3.5525758738211527`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ListPlot", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.005", "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Thickness", "[", "0.005", "]"}]}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4717183464730062`*^9, 3.471718370868517*^9}, {
  3.4717191281323137`*^9, 3.471719135416394*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindSpikes", "[", 
    RowBox[{"vTraj_", ",", 
     RowBox[{"startV_:", "0"}], ",", 
     RowBox[{"endV_:", "-", "5"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "spike", ",", "spkTimes", ",", "remainder", ",", "startLoc", ",", 
       "spkLoc"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"spike", "=", "False"}], ";", "\[IndentingNewLine]", 
      RowBox[{"spkTimes", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"vTraj", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], ">", "startV"}], "&&", 
            RowBox[{"!", "spike"}]}], ",", 
           RowBox[{
            RowBox[{"spike", "=", "True"}], ";", 
            RowBox[{"startLoc", "=", "i"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"vTraj", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], "<", "endV"}], "&&", 
            "spike"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"spike", "=", "False"}], ";", "\[IndentingNewLine]", 
            RowBox[{"spkLoc", "=", 
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"vTraj", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"startLoc", ";;", "i"}], ",", "2"}], "]"}], "]"}], 
                ",", 
                RowBox[{"Max", "[", 
                 RowBox[{"vTraj", "[", 
                  RowBox[{"[", 
                   RowBox[{
                    RowBox[{"startLoc", ";;", "i"}], ",", "2"}], "]"}], "]"}],
                  "]"}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"AppendTo", "[", 
             RowBox[{"spkTimes", ",", 
              RowBox[{
               RowBox[{"vTraj", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"startLoc", ";;", "i"}], ",", "1"}], "]"}], "]"}], 
               "[", 
               RowBox[{"[", "spkLoc", "]"}], "]"}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "vTraj", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"spike", ",", "\[IndentingNewLine]", 
        RowBox[{"remainder", "=", 
         RowBox[{"Most", "[", 
          RowBox[{"vTraj", "[", 
           RowBox[{"[", 
            RowBox[{"startLoc", ";;"}], "]"}], "]"}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"remainder", "=", 
         RowBox[{"{", "}"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"spkTimes", ",", "remainder"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.517593691419849*^9, 3.517593774998214*^9}, {
  3.517593957733959*^9, 3.517594094138661*^9}, {3.5175943280942307`*^9, 
  3.517594442730784*^9}, {3.5175945825289717`*^9, 3.517594781835615*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SaturateDeriv", "[", 
   RowBox[{"x_", ",", "linearMax_", ",", "absoluteMax_"}], "]"}], ":=", " ", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"x", "\[LessEqual]", "linearMax"}]}], " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sech", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "linearMax"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"absoluteMax", "-", "linearMax"}], ")"}]}], "]"}], "^", 
        "2"}], ",", 
       RowBox[{"x", ">", "linearMax"}]}], " ", "}"}]}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.517915631257001*^9, 3.517915654951819*^9}, {
   3.517915685185953*^9, 3.51791574919453*^9}, {3.517915785011598*^9, 
   3.517915799180004*^9}, 3.5179158904738007`*^9, {3.5179159378105917`*^9, 
   3.517915975771882*^9}, {3.517917534973076*^9, 3.5179175359953127`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Basic Gating Functions", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
  3.471719164381555*^9, 3.4717191680331707`*^9}, {3.515524637429166*^9, 
  3.5155246401089277`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xInf", "[", 
   RowBox[{"v_", ",", "vH_", ",", "vS_"}], "]"}], ":=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v", "-", "vH"}], ")"}], "/", "vS"}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4527978634138393`*^9, 3.452797937921638*^9}, 
   3.4717813896084538`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xTau", "[", 
   RowBox[{
   "v_", ",", "t1_", ",", "t2_", ",", "vH1_", ",", "vS1_", ",", "vH2_", ",", 
    "vS2_"}], "]"}], ":=", 
  RowBox[{"t1", "+", 
   RowBox[{"t2", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v", "-", "vH1"}], ")"}], "/", "vS1"}], "]"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v", "-", "vH2"}], ")"}], "/", "vS2"}], "]"}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.513457360164835*^9, 3.513457400569716*^9}, {
  3.513457433891304*^9, 3.513457477629838*^9}, {3.513457515071529*^9, 
  3.513457519255034*^9}, {3.517667450886408*^9, 3.517667475597788*^9}, {
  3.517667748257183*^9, 3.517667769066613*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xDot", "[", 
   RowBox[{"x_", ",", "xInf_", ",", "tau_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"xInf", "-", "x"}], ")"}], "/", "tau"}]}]], "Input",
 CellChangeTimes->{{3.4527979697370358`*^9, 3.45279804490091*^9}, {
  3.487698672830111*^9, 3.487698690022458*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Voltage-Dependent Conductances", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
  3.471719164381555*^9, 3.4717191680331707`*^9}, {3.513452748994402*^9, 
  3.513452753560677*^9}, {3.513460999550459*^9, 3.5134610000206337`*^9}}],

Cell["\<\
TempAdjust returns a factor that can be used to adjust model parameters (time \
constants or conductances) to the values they should adopt at different \
temperatures.  A parameter is adjusted by multiplying it by the factor \
returned by TempAdjust\
\>", "Text",
 CellChangeTimes->{{3.552573257080205*^9, 3.5525733903389482`*^9}, {
  3.552573429951189*^9, 3.552573462713044*^9}, {3.5525734977313538`*^9, 
  3.552573533100204*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TempAdjust", "[", 
   RowBox[{"tempBase_", ",", "tempTarget_", ",", 
    RowBox[{"Q10_:", "3"}]}], "]"}], ":=", 
  RowBox[{"Q10", "^", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"tempBase", "-", "tempTarget"}], ")"}], "/", "10"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5140577492518187`*^9, 3.5140578886586857`*^9}, {
   3.5155249187550707`*^9, 3.5155249340203753`*^9}, {3.517671728893957*^9, 
   3.517671734772573*^9}, 3.517752598843006*^9, {3.552572242666131*^9, 
   3.5525722441986227`*^9}, {3.5525732341440973`*^9, 3.5525732477954073`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tempZF", "=", "41"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"zebra", " ", "finch", " ", "body", " ", "temperature"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempRoom", "=", "25"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "during", " ", "unheated", " ", 
    "slice", " ", "recordings"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.514061011132704*^9, 3.514061047745885*^9}, {
  3.517670452984321*^9, 3.517670453215722*^9}}],

Cell[CellGroupData[{

Cell["Spiking Na (instantaneous activation) -- Na", "Subsection",
 CellChangeTimes->{{3.513452858845728*^9, 3.5134528756218567`*^9}, {
  3.5134585153303213`*^9, 3.513458523488674*^9}, {3.513459000678787*^9, 
  3.513459009901409*^9}, {3.513459616665099*^9, 3.5134596311681337`*^9}, {
  3.515527248188558*^9, 3.515527250220351*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaNa", "=", 
    RowBox[{"-", "24"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaNa", "=", 
    RowBox[{"-", "7"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nNa", "=", "3"}], ";"}], "              ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfNa", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaNa", ",", "vSaNa"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mNa (black) and mNa^\>\"", "<>", 
    RowBox[{"ToString", "[", "nNa", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfNa", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfNa", "[", "v", "]"}], "^", "nNa"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.513459450767704*^9, 3.513459454056691*^9}, {
   3.5134595277832537`*^9, 3.513459528605165*^9}, {3.513459576711626*^9, 
   3.513459576951315*^9}, {3.515525343950225*^9, 3.515525404610326*^9}, {
   3.517667894075156*^9, 3.517667895225582*^9}, {3.5176796562284517`*^9, 
   3.517679677957939*^9}, 3.517686473244102*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwV13c81d8fB/CIMpIZkpm9tyK8P1zjmve6fFMkGiIlyoooJUUyk2STvTKy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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVl3c8V/8Xx+3KyEj2FyF7y8zn/b725uNDKqVURERklSizkoyKklRS9kh2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mNa (black) and mNa^3 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364384866804*^9, 3.5184400327760687`*^9, 
  3.518642333232915*^9, 3.5187028882454233`*^9, 3.549977803919505*^9, 
  3.552325749782489*^9, 3.552326803916441*^9, 3.5523966582348213`*^9, 
  3.5524171946682158`*^9, 3.552417248049036*^9, 3.552419091623473*^9, 
  3.552574110036849*^9, 3.552583873405993*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["steady-state inactivation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513458864673243*^9, 3.513458864735363*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHiNa", "=", 
    RowBox[{"-", "60"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "inactivation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSiNa", "=", "6.7"}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"inactivation", " ", "slope", " ", "factor"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inactInfNa", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHiNa", ",", "vSiNa"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{
   "\"\<steady-state Na inactivation (blue)\\nplotted with activation (mNa^\>\
\"", "<>", 
    RowBox[{"ToString", "[", "nNa", "]"}], "<>", "\"\<, red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"actInfNa", "[", "v", "]"}], "^", "nNa"}], ",", 
     RowBox[{"inactInfNa", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.513458883545854*^9, 3.513458895737816*^9}, {
   3.5134589339732857`*^9, 3.5134589472042913`*^9}, {3.5134594834890957`*^9, 
   3.5134594844189253`*^9}, {3.51345983156503*^9, 3.513459862562852*^9}, {
   3.5152847288023157`*^9, 3.515284738261936*^9}, {3.515525503789123*^9, 
   3.515525526079124*^9}, {3.515525563632688*^9, 3.515525648788661*^9}, 
   3.5155281576715517`*^9, {3.517667973839048*^9, 3.517667978092712*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVl3c8V/8Xx+3KyEj2FyF7y8zn/b725uNDKqVURERklSizkoyKklRS9kh2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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVl2c41w8Xxs3IKFv97C3zZ2Z+z9cmIyNJUioVSlYSKiIyIoqoVMis7BEy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state Na inactivation (blue)\\nplotted with activation (mNa^3, \
red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364384897891*^9, 3.5184400328059683`*^9, 
  3.518642333270872*^9, 3.5187028882835712`*^9, 3.549977803958006*^9, 
  3.552325749820754*^9, 3.552326803990285*^9, 3.5523966582664557`*^9, 
  3.552417194729076*^9, 3.552417248077533*^9, 3.552419091671899*^9, 
  3.55257411007652*^9, 3.552583873439185*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["inactivation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}, {
   3.513458793285729*^9, 3.513458804092909*^9}, {3.513458868600246*^9, 
   3.513458868679677*^9}, {3.515338272246876*^9, 3.5153382730047617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1iNa", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2iNa", "=", "14"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH1iNa", "=", 
   RowBox[{"-", "120"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1iNa", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2iNa", "=", 
   RowBox[{"-", "60"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vS2iNa", "=", "12"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempNa", "=", "37"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", " ",
     "kinetics", " ", "apply"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10iNa", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempNa", ",", "tempRoom", ",", "Q10iNa"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempNa", ",", "tempZF", ",", "Q10iNa"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<inactivation time constant for Na at \>\"", "<>", 
    RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
    RowBox[{"ToString", "[", "tempNa", "]"}], "<>", "\"\<, and \>\"", "<>", 
    RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inactTauNa", "[", "v_", "]"}], ":=", 
  RowBox[{"xTau", "[", 
   RowBox[{
   "v", ",", "t1iNa", ",", "t2iNa", ",", "vH1iNa", ",", "vS1iNa", ",", 
    "vH2iNa", ",", "vS2iNa"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qRoom", " ", 
      RowBox[{"inactTauNa", "[", "v", "]"}]}], ",", 
     RowBox[{"qZF", " ", 
      RowBox[{"inactTauNa", "[", "v", "]"}]}], ",", 
     RowBox[{"inactTauNa", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.517659370444151*^9, 3.517659458158696*^9}, {
   3.51765951598639*^9, 3.51765969248174*^9}, {3.517659741124271*^9, 
   3.5176598800979033`*^9}, {3.5176599131487293`*^9, 3.517659980869519*^9}, {
   3.517660107259983*^9, 3.517660124405079*^9}, {3.517660168016409*^9, 
   3.517660188705079*^9}, {3.517664297866303*^9, 3.517664402525186*^9}, {
   3.517666851472773*^9, 3.5176669182186003`*^9}, {3.517668017707142*^9, 
   3.517668030786314*^9}, {3.517668124061599*^9, 3.517668164196578*^9}, {
   3.517668852396811*^9, 3.517669126597953*^9}, {3.517669189249436*^9, 
   3.517669208336926*^9}, {3.517669278062071*^9, 3.517669302605089*^9}, {
   3.5176693482809258`*^9, 3.517669362496118*^9}, {3.517670535286792*^9, 
   3.517670544055212*^9}, {3.5176706344835157`*^9, 3.517670634738987*^9}, {
   3.517671798955681*^9, 3.517671802875463*^9}, 3.517752541213345*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVjns0lHkch0cuhzXk0hF2Iok0Msy8Q9Ll/brMNJdmwxRi16KaLZditbSn
4eTaRbqcpKldR7UWbc3E2bKR8jNymVWtdduUSyS2m1DMmJned+0fz/mc56/P
45JwMHzvEgqFIlrk/1XUpKpJUozM2RNvEqa4kGrB+NGMEKOxOgdj2jsuMBPf
am30YrRPdn5Z72su3HaVEG4aMTpQXmcT+IoLDaUxxtumxWhQLzhmOciFVinX
VvZCjGbUM4xMFRcGeTRvn2Yxejl19UD2L1wwH22XxOWK0UDRmP83O7jgWp7c
5K0NR32PD+8iL3HAvEqXZ3wkHH3AJ8+UDISATQMM7yLCUMFPYfQ58xDoi+5x
WZEZhhgJs4oux2DYxwn9e0ITihJyMo9x6EFQd98x0Tk1FJVdH890Xh4IW3P9
mPKe7cji66OxljocWmhUicfAVyiki/1QM7IZ6rqlKTkqERI2O1BLz24EAU25
bbJzG3q2f/cZzf4NQJOmRwp6hMh7Z8ufQxHrYY+6iV3UKkDUINnp2TW+IDIZ
ff1UxUfZKfrCBTYGcp+yNKN6HrrW5hx/2I8JwrTW1V7yrWj+t/nbjR0MOMlR
3kr4nYskGykxJlWegPtGW2RUcNDcikf/aIs94MLdtqDSqhBEF11jqmbcICHy
iaDkQjCq5/MuRia6Qgo1KPvM8SDE6X1bK/N3AfudJ09cLA5E92YV9tW9ThBQ
n/JdVhagm3bnIE7yJSzECwNeEFsQPb/NK+1ne1jIOq9vom5GXHl7hGWAHUx2
We+JmQ5AZcmHFMLPtrBcuOGIlcYf7Yi1fGnPtAFffen6nD4/NH+6/dSWAit4
MvBI8K6RjYZb+P4RuCVUD9+wSOtgIey9h9WUERVSHZt/qL3ug4aweIVwzgzm
tITj8lgvZLL+aeO34aZAcVynaZKuRfav7zCNPprAZGWr8wuuG+I/2dTVrDCG
sNzaSmyXC8ozXtpiqjACxkXbab2XI8qKlXwKUBoCatsXtrDBBvGVo6uppoZw
JHQz7cFzI5RBfwUVyUvAM7Jf61s00mT78A0xMWQAPIMs4NaoccrS6CJhigE8
WObe/9dHKqjaq0+BiQEcXVX5pnfEDsojC3lhtRS4XFbiGXPHCeqi/FfuOECB
bKe+pIVLrhB1/1Gb2ocCN8uLx6zPrYHwKDGtkkKB8fYLN3wPecJGKZveWUPi
kMukj93whqS1o8afJCRukXm/Qv6YCZaT/8pV60h806mr7zP6meBumjr7zJPE
E68W+MEIE0QFuvF3dBLv6BR1dE8z4biDe7fNWhLPXTn8Vm3LgpIt5k0SNxLX
qAhWUDQLDkYIMhhOJD5Gg+b+CRZ49x0yCbAicWvW6i+ufGCBU7JgRdzSxZ6t
puL9GhYMdRv0FFqSeFla17jODANPEc+hn0riUW1xpi5eGFg8/9VIakbijw/m
bE9Kx+BWUuDH8SUkrs/fK2NLMWjLVCqXLTr9Mn/0cz4GNVds6RwDEj/+0Dr9
bCkGvXPJD6pIAg9yuFZ6px4DTo9uJl1P4GmMwpFsJQYN9br0ah2BXwlO9OB1
YtDpHn9ySEvgn1NYDc8GMWheJf+ev0Dg6/LsDCteLf7faww+qiHwaJlWmDKF
wdOpvKo/1AR+Qj5c4qfGINRQVvZhnsDvKpVDJInB7uLTbh6L/h+HGEyQ
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVx3s0lGkcwHEVJZcOo5RZTKKtdW3mRdHl+TW5z8hlttxKpZo0knEUbYNq
SNFltXLdFUrYZGN3S5yNZ2YRSSv1TmYII5eKivZohsZY+8f3fM/HIiIm8PBC
DQ0N3/n+/2/VfMXcHAcPNk0P15bQgK9v/8NSNQfXXf5dknWDBnTe2AxFxcFl
3OSg4z/T4E9LrnqtkoM5O6O1adk0qM8J02JPcHBXcYZFzEUaNCd6GOUNcHDR
B5nGk+M06PUyddgg4uBx83ito6400JU/5u4XcrCoZk62vcMcLIuONTrMBOLg
Yh2V3VMz0C3/mqIlCMQ6vTYpIrEpUOqhL0QdgMVF2k1m5d8AGfrCwiwhAK85
/156OpQKke7+z0eU/tgkKYtfucwEHjyi8mh8f3yyc+oNLWsleAqd6VUv/PBk
1G71vWXG8LepHne9dCemLznhNlCwHB50JUafa/PFdzlfJ2cXGoGPqZg92s7G
bpsXe7peMATTxLggnxcsrGsbnDK2ygAOKRodLzX74NrS1Yd77PXBd7H8XXeb
N5Y+u52fmawDVRsKYzXrvHB+gSB/b8MSYMU2W9lVeWJdwcFC3mYtyHAX34v4
wwM79r3uTqAsAuQUqh9f6o65H8jjZz5pQPbDFmZOuRuuatN87uGuRhFBz3yu
Z+/AaesUbPvWGRStx0z+8SITw4VtfLZIgVbtykjPvbIdn79d4nBrxxRyrYs+
kpQEeGrRJ2P58Gc0fYDlOqDehs2uNilOTU+g6aQsVaPeVuxWx72pqPiIRjsN
D4VNuGILbxeroZ/G0EqWi8BAuQmnnnjfsmLVO+Skytl4jnTGd3enFQ+3jaBn
0qc+4385YkqeQVxZ7xCq6KvUj21l4J47UtjCeYP4VNHJml834PS0SxsDR+Vo
akZNXRluh/XOVhgfbBlAGlRbZWPid9g1UvWGWtGPRsuaaQMea/HnsRhZ59vX
KEBYU0aEWGDqUIx2dVovss81mlDZUbF4/MYu3vYehFsiA6ZdKJhuiA/kggwJ
/LeaNvRo4mJtvmgTT4psgiQzTpf6GwVt14w4t7uR14Ik8KhWoKRX8V9ml3aj
huXfSv75Vw9CbsWzZIJX6Oyasvcv+41hgXX4lprFr1BB4XWbsPvmwBRJ93nf
kaBkczJqOt8SXPJOzZbukqC7RVcGDa+tA79gha6aIkFDj7MrnU7YwPdHmp8k
9JAIhHTrwUoHqA9n0zIqSKSf8Ki0qoMOQ9UPzY6dJdGWyyUf4iV0aGV1nXx8
hkS8kvPO0E8Hud+ku+W8W9t9W7sm6NA2OcjuTSKRcHXfmMKIAcpxk3GOgETK
NjWDGcqAxswOq5B4Eg2agkgywgAb+VWi7hiJDBlWOsWfGFDyUfPtmnmDpzbn
qJIBlSsMdK5EkagwtnPo61IChE7l2RE8EgW37Ne2sCOgdsJBTIkkUUfMOb+o
OAJy22m2Fw6SSJV6OM8xkYBwG91sRQSJrAu85bOpBDidruRGzvtik2FcZg4B
fkIZk3WAREyTmzn36whQX66UrNhHolj7tP5kMQHBjC+J6eEkKt7BW+/VTsBA
ZkH67F4SzUYz6mW9BFBGW16O7CGRbYrxotLhef9ST9kz79C8GVb0RwLyU/vv
Pw8jUXpV33VnBQHrtcYfec77oVj8em6OgJTaHOuGUBL9B91nX+o=
     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwVzHs0lHkcx3GKUqjQCrkLk/vMg8q2/b4pt9Hk8tQKRVmslCKl7Rgy0+U0
XbUxhlYSx+gIXTYpq/lRY4h0kdFUeKiw2UpZDZMZO/vH57zP65+PTdze8IRZ
GhoaLPX+b831VPnMDIkbr437eZ6iQaq+26F5KhK7NeXGPTxBA3ryqMJwmsQZ
h2/uII/T4E+7RJX9JIn7Lr6Ys4dDg3v8aO0NYyReK3kxnH+QBmK2v5GAIvH2
WkF/7S80eBNo7u7RRGKTnA883R9poDsgSdzOJXFR9M2OyCFHsCvZLXJXhGPe
KK+PsnQEXeH3I9qZajt/M/0U6gCG96AvUhWGkxYuVb3cbw/dUV02FgfDsGlP
SZRo3zJI8gt9NjQZilkhIV1BaXZQ12iWbJUaii2lsp2PmLYQwPWmV3eF4J+X
r2uIt7CBB+Z6iTTZRizj9Gi1T1lB3XN2CqeNhUdik0ae5VgA07x5w3D7BmzC
sZ/JJJaCOTs9gtkVjJnGzro6300gXi7yPCVm4iObWt53lhsDa87A3y/bgrC2
baCt6OxiqPYoTtO6G4hllU7CiN2GEJwmXuZaHYDrxJHCjEOL4KRfc23cLX88
kvzVSSrQB+QVpZ9R7odpNdlD2oHzIb++xZcvXI/FwrlWPey5EBfRyczLX4e7
v67+0ivRghQ93+xzJ3xx4qBizaU9s8Bk80lewZm1uJB7oKznsAb43E35NSsL
MNdtgU85qURTO4J9KNUa/O12YUFOhAJNZV2YFun9hF2cXTbSH8nR8FOD+Ogx
H6xwJc86JkygJcGrMhdNrsRjppcXCn4bR17T/BWcbm/ce1gQLqz5gjplHcx/
/vLEqgp22Sf3MVTZV6Wf1srAm8ueJmxRfkSpZk0Hblz1wC21T1gXW0fRhEJl
tiTGFYf/sOL+Kp0PSMPMZVLEXo7LyYohWu4IGq4QW1H+9jjW+sYCU69hFMa9
UUFE2uBG3Zht4bZDyK3AaGza1QyXZplwP9u/R7glKWxqlSG+KVs0XhnzDmWG
/mR+/7UWll3dH0vWv0XOEVKF16l+kc1y4sBpq7coUDML/K/LkaH8UYe2cBDd
X+wgfTKuB3JupqRh5SDKsa348KLfGNKtV2Z29Q6gouI85+jblnDMefZWa/4A
yrbs3jVVaAedm8Tb0jcNoGslZwYNzjvCvHi5tMF6AL2T5Fd57XeGPfYT1yom
KARcutNglTuEGW1Ot+2kkP7BxvLqx3SYalDe0ayl0OrTpR8zpHQQG8dOcGoo
lFx6zBv66XBISZ2bpXZrO6v1+Rgdzo2ueK1VTSGudd+o3IgBbTE9D/SrKDTZ
pmL4RjEAt5Zd8RBSaNAcmqRDDFB2JHXWl1DIgLFs/uXPDODVbPVYrzYE6JA7
JxngXhQx/OQShYrTnr77Po+ABft2kSPFFNrSsl3HxpWAgMWkhcUfFHq8lxOy
K50AWeFXX76AQtNHEwSebAKOMRtfOqjtVBQ0oDxKQNDJFtGdAgqdeGiQnstX
//Eqc17xKeRreoV/+67aeWskdvkUSnM73p/dTIBTaS5Vl0ehy+uSaYHtBIzQ
WUFMtZUpjHuv3hCApyx19l2gkMsR49nl7wn45tC0bY7aUQJFcMonAiQPhjUv
/k4hXnVfnrecgKW3Iv91V7u+ubl3ZoYAV80+T/F5Cv0HDNleQg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"inactivation time constant for Na at 25, 37, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364384924416*^9, 3.5184400328327007`*^9, 
  3.518642333305043*^9, 3.518702888316596*^9, 3.549977803993972*^9, 
  3.5523257498674088`*^9, 3.5523268040407667`*^9, 3.552396658296789*^9, 
  3.5524171947730093`*^9, 3.552417248110955*^9, 3.55241909171839*^9, 
  3.5525741101288147`*^9, 3.5525838734796953`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kv3.1/3.2 (delayed rectifier) -- Kdr", "Subsection",
 CellChangeTimes->{{3.513452858845728*^9, 3.5134528756218567`*^9}, {
  3.515526757503654*^9, 3.515526761215626*^9}, {3.5155272536926413`*^9, 
  3.5155272553806067`*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaKdr", "=", 
    RowBox[{"-", "12"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaKdr", "=", 
    RowBox[{"-", "7"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nKdr", "=", "2"}], ";"}], "              ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfKdr", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaKdr", ",", "vSaKdr"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mKdr (black) and mKdr^\>\"", "<>", 
    RowBox[{"ToString", "[", "nKdr", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfKdr", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfKdr", "[", "v", "]"}], "^", "nKdr"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
  3.513453012180917*^9, 3.5134531007944183`*^9}, {3.515526829197652*^9, 
  3.515526897535104*^9}, {3.517929938998232*^9, 3.5179299425166597`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwV13c01+8XAHAkyU5CdvaeJYT7tjcfn4+WUiqECBGlaUVKISTJKivJSFKK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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVl3c8198Xxyl7JZSRlFFWdjb3vu2P/fFRRCUNJRIZyYgQZUdWkpAIJTtk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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mKdr (black) and mKdr^2 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364384952819*^9, 3.5184400328624973`*^9, 
  3.518642333340712*^9, 3.518702888368491*^9, 3.5499778040406313`*^9, 
  3.5523257499163647`*^9, 3.552326804090537*^9, 3.5523966583484364`*^9, 
  3.552417194826933*^9, 3.552417248151235*^9, 3.552419091764258*^9, 
  3.552574110178154*^9, 3.5525838735244513`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1aKdr", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2aKdr", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH1aKdr", "=", 
   RowBox[{"-", "14.6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1aKdr", "=", "8.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2aKdr", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vS2aKdr", "=", 
    RowBox[{"-", "15"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempKdr", "=", "37"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", " ",
     "kinetics", " ", "apply"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10aKdr", "=", "3"}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempKdr", ",", "tempRoom", ",", "Q10aKdr"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempKdr", ",", "tempZF", ",", "Q10aKdr"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<activation time constant for Kdr at \>\"", "<>", 
    RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
    RowBox[{"ToString", "[", "tempKdr", "]"}], "<>", "\"\<, and \>\"", "<>", 
    RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"actTauKdr", "[", "v_", "]"}], ":=", 
   RowBox[{"xTau", "[", 
    RowBox[{
    "v", ",", "t1aKdr", ",", "t2aKdr", ",", "vH1aKdr", ",", "vS1aKdr", ",", 
     "vH2aKdr", ",", "vS2aKdr"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qRoom", " ", 
      RowBox[{"actTauKdr", "[", "v", "]"}]}], ",", 
     RowBox[{"qZF", " ", 
      RowBox[{"actTauKdr", "[", "v", "]"}]}], ",", 
     RowBox[{"actTauKdr", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.5176737490670013`*^9, 3.517673751162981*^9}, {
   3.517675521661262*^9, 3.5176755221233187`*^9}, 3.5177525872149343`*^9, {
   3.51776570268845*^9, 3.5177657213121233`*^9}, {3.517929976096292*^9, 
   3.517929976174951*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nk0ltsXB3AyZy5dkjFTptczvObq3Ul6MyVkSKmEXK4MzRFNXJJGQ0hp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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1nk0Vfv7B3BDOc7eplC64mSeOfucYxb7kzkiQxlC30gSiUiToZKURiVT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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1nk8VN0bAHCS0ith5k6ksYx9nzszliy555UQkaXdUkm9spRoe7NUohJt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"activation time constant for Kdr at 25, 37, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385002359*^9, 3.518440032899761*^9, 
  3.5186423333995523`*^9, 3.518702888413054*^9, 3.549977804095969*^9, 
  3.552325749964275*^9, 3.552326804166301*^9, 3.552396658400374*^9, 
  3.552417194988455*^9, 3.552417248183494*^9, 3.552419091818244*^9, 
  3.552574110229031*^9, 3.552583873584552*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kv4 (rapidly inactivating K current) -- A", "Subsection",
 CellChangeTimes->{{3.513452858845728*^9, 3.5134528756218567`*^9}, {
   3.5134585153303213`*^9, 3.513458523488674*^9}, 3.513511323861285*^9, {
   3.514221824200597*^9, 3.5142218276549187`*^9}, {3.515527219395811*^9, 
   3.515527265421051*^9}, {3.515528290050802*^9, 3.515528297793622*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaA", "=", 
    RowBox[{"-", "60"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaA", "=", 
    RowBox[{"-", "8.5"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nA", "=", "4"}], ";"}], "              ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfA", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaA", ",", "vSaA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mA (black) and mA^\>\"", "<>", 
    RowBox[{"ToString", "[", "nA", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfA", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfA", "[", "v", "]"}], "^", "nA"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "90"}], ",", "0"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.514221852792184*^9, 3.5142218558160963`*^9}, {
   3.515345225181307*^9, 3.515345228351499*^9}, {3.5155275514684887`*^9, 
   3.5155276031828213`*^9}, {3.515528094411598*^9, 3.515528118508649*^9}, {
   3.5155283159976177`*^9, 3.5155283248526373`*^9}, {3.515606646597389*^9, 
   3.515606665091648*^9}, {3.51715383854277*^9, 3.517153838693666*^9}, {
   3.517670761440097*^9, 3.517670764430809*^9}, 3.517840510485405*^9, {
   3.517927573636921*^9, 3.517927573756048*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwV03k4lVsXAPA0p0wVyVDmqcSVeVpmCRnOOYaUDCnCMWdIkUrlCklu5aJD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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1nc4l98bB3ChQhmpZKRQZFSEbM9tZJT12UaSWWTvEZUkklmSNCWprEhF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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mA (black) and mA^4 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385035295*^9, 3.518440032928968*^9, 
  3.518642333439489*^9, 3.5187028884445457`*^9, 3.549977804145339*^9, 
  3.55232574999722*^9, 3.5523268043089046`*^9, 3.55239665845094*^9, 
  3.5524171950391693`*^9, 3.552417248229816*^9, 3.552419091870347*^9, 
  3.552573912296858*^9, 3.5525741102781477`*^9, 3.552583873623958*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["steady-state inactivation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513458864673243*^9, 3.513458864735363*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHiA", "=", 
    RowBox[{"-", "78"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "inactivation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSiA", "=", "6"}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"inactivation", " ", "slope", " ", "factor"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inactInfA", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHiA", ",", "vSiA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{
   "\"\<steady-state A inactivation (blue)\\nplotted with activation \
(mA^\>\"", "<>", 
    RowBox[{"ToString", "[", "nA", "]"}], "<>", "\"\<, red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"actInfA", "[", "v", "]"}], "^", "nA"}], ",", 
     RowBox[{"inactInfA", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "90"}], ",", "0"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513453111003118*^9, 3.513453181572648*^9}, 
   3.513457942308256*^9, {3.513458725101942*^9, 3.5134587297227297`*^9}, {
   3.513458905403673*^9, 3.513458924814267*^9}, {3.514221893812447*^9, 
   3.514221897020445*^9}, 3.514221930376923*^9, {3.515527956434649*^9, 
   3.5155279570667553`*^9}, {3.515528177384358*^9, 3.515528203743281*^9}, {
   3.5155283356472692`*^9, 3.515528343352551*^9}, {3.515606699560624*^9, 
   3.515606701430394*^9}, {3.517670778047225*^9, 3.517670780727635*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1nc4l98bB3ChQhmpZKRQZFSEbM9tZJT12UaSWWTvEZUkklmSNCWprEhF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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVl3c8148TxxGKEBEhGdl7b++zPvb4IEJGRkIqVEJ2GU2SWUlGGZF8jYi4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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state A inactivation (blue)\\nplotted with activation (mA^4, \
red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.5183643850727654`*^9, 3.518440032961918*^9, 
  3.518642333472767*^9, 3.5187028884781933`*^9, 3.549977804192296*^9, 
  3.552325750031543*^9, 3.552326804353705*^9, 3.5523966584793997`*^9, 
  3.552417195081544*^9, 3.552417248283003*^9, 3.5524190919217033`*^9, 
  3.552573912464056*^9, 3.552574110327702*^9, 3.552583873676951*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1aA", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2aA", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH1aA", "=", 
   RowBox[{"-", "50"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1aA", "=", "8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2aA", "=", 
   RowBox[{"-", "70"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vS2aA", "=", 
    RowBox[{"-", "8"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempA", "=", "23"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", " ",
     "kinetics", " ", "apply"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10aA", "=", "3"}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempA", ",", "tempRoom", ",", "Q10aA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempA", ",", "tempZF", ",", "Q10aA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<activation time constant for A at \>\"", "<>", 
    RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
    RowBox[{"ToString", "[", "tempA", "]"}], "<>", "\"\<, and \>\"", "<>", 
    RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"actTauA", "[", "v_", "]"}], ":=", 
   RowBox[{"xTau", "[", 
    RowBox[{
    "v", ",", "t1aA", ",", "t2aA", ",", "vH1aA", ",", "vS1aA", ",", "vH2aA", 
     ",", "vS2aA"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qRoom", " ", 
      RowBox[{"actTauA", "[", "v", "]"}]}], ",", 
     RowBox[{"qZF", " ", 
      RowBox[{"actTauA", "[", "v", "]"}]}], ",", 
     RowBox[{"actTauA", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", 
     RowBox[{"-", "20"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "80"}], ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.5176737490670013`*^9, 3.517673751162981*^9}, {
   3.517675521661262*^9, 3.5176755221233187`*^9}, 3.5177525872149343`*^9, {
   3.51776570268845*^9, 3.5177657213121233`*^9}, {3.5177785777656517`*^9, 
   3.517778728420285*^9}, {3.517778901261119*^9, 3.517778951165303*^9}, {
   3.517779001065216*^9, 3.517779003759387*^9}, {3.517779155102839*^9, 
   3.5177791642698927`*^9}, {3.517779310373632*^9, 3.5177793531499367`*^9}, {
   3.517831657370152*^9, 3.517831702016336*^9}, {3.5178317373228407`*^9, 
   3.517831788714677*^9}, {3.517832304339867*^9, 3.517832344394607*^9}, {
   3.517838506148687*^9, 3.5178385372049627`*^9}, {3.5178387405443697`*^9, 
   3.517838857067531*^9}, {3.517838899062524*^9, 3.517838951249145*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nk8VO0XAPDR3FuWyhIlUSpLUZGmQeg+hGjm3hkmtKlIb+qVktCqVEq0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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV13lcDe0XAPBIlEJShLRpQUVy25ejRVruzL2KNpJWW4vqfQsl+1siilAk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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1nk4VV0XAHAy3XNIpkrSYErRoLpE6GxDIvece3ORoTmViojiNTRTCKV8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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-80, 0},
  PlotLabel->FormBox[
   "\"activation time constant for A at 25, 23, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385110382*^9, 3.518440032999839*^9, 
  3.518642333531913*^9, 3.51870288853473*^9, 3.549977804239847*^9, 
  3.552325750070137*^9, 3.552326804404345*^9, 3.55239665853815*^9, 
  3.552417195123495*^9, 3.5524172483319263`*^9, 3.5524190919718246`*^9, 
  3.5525739125376587`*^9, 3.552574110379683*^9, 3.5525838737270403`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["inactivation time constant (fixed, voltage-independent)", \
"Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}, {
   3.513458793285729*^9, 3.513458804092909*^9}, {3.513458868600246*^9, 
   3.513458868679677*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"inactTauA", "[", "v_", "]"}], ":=", "20"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10iA", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempA", ",", "tempRoom", ",", "Q10iA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempA", ",", "tempZF", ",", "Q10iA"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<A current inactivation time constant at \>\"", ",", "tempRoom", ",", 
   "\"\< and \>\"", ",", "tempZF", ",", "\"\< deg C: \>\"", ",", 
   RowBox[{"N", "[", 
    RowBox[{"qRoom", " ", 
     RowBox[{"inactTauA", "[", "0", "]"}]}], "]"}], ",", "\"\< ms, \>\"", ",", 
   RowBox[{"N", "[", 
    RowBox[{"qZF", " ", 
     RowBox[{"inactTauA", "[", "0", "]"}]}], "]"}], ",", "\"\< ms\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.513458809322195*^9, 3.513458823438694*^9}, 
   3.514221884474872*^9, 3.515527886583037*^9, 3.5155283540584784`*^9, {
   3.517670819926249*^9, 3.517671043426475*^9}, {3.517671575497959*^9, 
   3.517671598625228*^9}, {3.517672576773052*^9, 3.517672617634552*^9}, 
   3.517752617381135*^9, {3.5525738688606167`*^9, 3.552573887306512*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A current inactivation time constant at \"\>", 
   "\[InvisibleSpace]", "25", "\[InvisibleSpace]", "\<\" and \"\>", 
   "\[InvisibleSpace]", "41", "\[InvisibleSpace]", "\<\" deg C: \"\>", 
   "\[InvisibleSpace]", "16.054831235204613`", 
   "\[InvisibleSpace]", "\<\" ms, \"\>", "\[InvisibleSpace]", 
   "2.768290976923372`", "\[InvisibleSpace]", "\<\" ms\"\>"}],
  SequenceForm[
  "A current inactivation time constant at ", 25, " and ", 41, " deg C: ", 
   16.054831235204613`, " ms, ", 2.768290976923372, " ms"],
  Editable->False]], "Print",
 CellChangeTimes->{3.518364385137198*^9, 3.51844003302979*^9, 
  3.518642333558456*^9, 3.5187028885598288`*^9, 3.549977804275269*^9, 
  3.552325750154376*^9, 3.552326804445372*^9, 3.552396658585631*^9, 
  3.552417195154853*^9, 3.552417248376402*^9, 3.552419092015747*^9, 
  3.552573912585909*^9, 3.5525741104294643`*^9, 3.552583873776578*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kv1 (slowly inactivating K current) -- D", "Subsection",
 CellChangeTimes->{{3.513452858845728*^9, 3.5134528756218567`*^9}, {
   3.5134585153303213`*^9, 3.513458523488674*^9}, 3.513511323861285*^9, {
   3.514221824200597*^9, 3.5142218276549187`*^9}, {3.515527219395811*^9, 
   3.515527265421051*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaD", "=", 
    RowBox[{"-", "50"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaD", "=", 
    RowBox[{"-", "15"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nD", "=", "3"}], ";"}], "              ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfD", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaD", ",", "vSaD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mD (black) and mD^\>\"", "<>", 
    RowBox[{"ToString", "[", "nD", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfD", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfD", "[", "v", "]"}], "^", "nD"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.514221852792184*^9, 3.5142218558160963`*^9}, {
   3.515345225181307*^9, 3.515345228351499*^9}, {3.5155275514684887`*^9, 
   3.5155276031828213`*^9}, {3.515528094411598*^9, 3.515528118508649*^9}, {
   3.517840486565839*^9, 3.51784049928529*^9}, {3.5179276442802343`*^9, 
   3.517927644382761*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVzns0lHkcx3GtmkPoNGxsaEood808mZYT319EY6RMUylKbRvrsjYi7eZS
Bq0hm8ptdWza2hRNTBcpjJ+pcUmp0Jwu7inFmEfbZczE2Gf/+Jz3ef33sdp3
YEv4Nzo6OoHU/u+1mjjV7Cwfb8ulRS3KlECckctv+lo+Hrf+0md/WgLM6HGN
8TQf63maTfqUS+CmdYTWdoqPfW+e+5DdIIG7RaHzNk7yMWacPLX9swRkKX4m
JYN87H9bnD4nsgl6OZauq5r5OMvUSP3YDoPBUGvEXgEfW7gJ1bYWzWB97ucm
V80W7J4XtmCQdw8MKr5mzEveglXyxgR2iQyM76L+nVoe1v9k+I+S1gbPQrqt
lhzmYe1Mae/ImwcQ6Rv09O1UELaj2yscHj6C2kbz6KVxQThxzbqJxqInsEHA
Zoq6N+MZK98/9uzugnuWhhF2LzZhfo5r6HlGD9R2pcSmtwdijrSLPciQA9dS
unG0YyM25e42aKE/B8uUhGBudwCO6TRZop7/EvarmlbnyriYoHvQxtb2QiBt
6P3zdn/cVf+0r53XD6JVZfFz73DwEYlL+82AQQiIl9k4izZgcWHZoiORQ5Dj
K63ed8MPV0lMe7/+MgzgFmKUdNEXu2bVJvRkvYbCuhbvoor1+LCF4uAhwQjs
C+7kFhT6YJoNOSwTvoFYQ++0k9neePSjdK366Fv4bluOsDhvHZaKn3Kido6C
x53Yn1JTEc7nhWnk7Heg/iHAY1DrhW2Xb759RkU59cx0k6EnrvO9n+JY8R5G
n9D3h056YL6j4Pf67WNgFuCevHDqexzyqYXeqRgDt+miNenP2PiU7lbRv8fG
ofPFQ66iYTVGORav9sxVwOX+KqP4NhZmv8y5YJuggDjz5kPiK6tw61DDa48B
BXzWaM3NwpxxT8aK9HL3CdAxd5pqSrHHpa1B652FEzB6SbZ00M8WxygP0Vjy
CeAJxJeInVZ4sUjuaG6qBJdik8lpZ3PcqvPZK5evBNwSyVO7G2P9YtoCznEl
JAd5WkpezcVh8cYL464rwTFYrnHLHWgaE4tn6nuVwJmTivxqVJAZd2YmY1YJ
km9XyB9/NESs4NuJlctIOLb80ljPgClK9EjMtfEkobSswDH0FgP9uCD2bNpW
EtIYz2LUf1qjbqfKybpoEq6eyxumn1qJaLyE6ncpJIy0Fla5JTqisg8j0rIT
JCAB02G4yhXZvPhom3+WBKPDjRdFj5jIwKttZWsFCWtPnJ9IkjPRXzUtazSU
o89nsdEAE31jJXRwvkxCW0dgW9ckE3Gjz9adpixY1j+uMmEhXdz4664rJEy1
a1neISykR2cUj1WSMGyJmuVvWchnU039BxEJdJbN/HKShfKyPX2srlF/Nujx
o6ZYKHxYWB1EuSz+ychXfQIxVpSxqynvaNmrZ+VMoIjkHTox1SQ8OpC+OSaB
QPrzdp3sqyFhOjO8ZHUKgXoWfYkyEJPgUOo/NJNJIJcQ5OBOOfs+PSG/iECO
l5ftKqDsvfjvolt3CNQsu3rc/zoJ8S7HB9KkBDpqFp6fRLncJ9qO00GgJGuf
Yxcoz8Sy7r7sJZBbcaXxDGWnDFPdi28IpJzDu2V/g4SQEk1ArJJAD52CvbZT
For6C9gqAtVmdYgElOuk0r7ZWQI9ONigW035P2Kta1c=
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVz3k4lAsbBnAkKRRSmGhTIsoylJDnjcKxzbwzRVGSgySy1iTLZ0tRKBkm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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mD (black) and mD^3 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385172987*^9, 3.5184400330631247`*^9, 
  3.5186423336046047`*^9, 3.51870288859245*^9, 3.549977804327389*^9, 
  3.5523257501860743`*^9, 3.5523268044919147`*^9, 3.552396658636479*^9, 
  3.55241719520671*^9, 3.552417248415761*^9, 3.552419092067062*^9, 
  3.552573959276572*^9, 3.55257411047998*^9, 3.552583873826391*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["steady-state inactivation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513458864673243*^9, 3.513458864735363*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHiD", "=", 
    RowBox[{"-", "70"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "inactivation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSiD", "=", "6"}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"inactivation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.513458883545854*^9, 3.513458895737816*^9}, {
   3.5134589339732857`*^9, 3.5134589472042913`*^9}, {3.514221888804673*^9, 
   3.514221891211837*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"inactInfD", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHiD", ",", "vSiD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{
   "\"\<steady-state D inactivation (blue)\\nplotted with activation \
(mD^\>\"", "<>", 
    RowBox[{"ToString", "[", "nD", "]"}], "<>", "\"\<, red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"actInfD", "[", "v", "]"}], "^", "nD"}], ",", 
     RowBox[{"inactInfD", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513453111003118*^9, 3.513453181572648*^9}, 
   3.513457942308256*^9, {3.513458725101942*^9, 3.5134587297227297`*^9}, {
   3.513458905403673*^9, 3.513458924814267*^9}, {3.514221893812447*^9, 
   3.514221897020445*^9}, 3.514221930376923*^9, {3.515527956434649*^9, 
   3.5155279570667553`*^9}, {3.515528177384358*^9, 3.515528203743281*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVz3k4lAsbBnAkKRRSmGhTIsoylJDnjcKxzbwzRVGSgySy1iTLZ0tRKBkm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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVl2c81//bhu1kZYskssne63197K89m1QqSiKrKKQyKlqSVSipkCIjI4rL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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state D inactivation (blue)\\nplotted with activation (mD^3, \
red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385234791*^9, 3.5184400331294622`*^9, 
  3.518642333705366*^9, 3.518702888667583*^9, 3.549977804390904*^9, 
  3.5523257502316113`*^9, 3.552326804569192*^9, 3.5523966587225037`*^9, 
  3.552417195278997*^9, 3.552417248476371*^9, 3.552419092164377*^9, 
  3.5525739594405317`*^9, 3.552574110569149*^9, 3.552583873903775*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1aD", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2aD", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH1aD", "=", 
   RowBox[{"-", "50"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1aD", "=", "8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2aD", "=", 
   RowBox[{"-", "70"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vS2aD", "=", 
    RowBox[{"-", "8"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempD", "=", "23"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", " ",
     "kinetics", " ", "apply"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10aD", "=", "3"}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempD", ",", "tempRoom", ",", "Q10aD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempD", ",", "tempZF", ",", "Q10aD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<activation time constant for D at \>\"", "<>", 
    RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
    RowBox[{"ToString", "[", "tempD", "]"}], "<>", "\"\<, and \>\"", "<>", 
    RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"actTauD", "[", "v_", "]"}], ":=", 
   RowBox[{"xTau", "[", 
    RowBox[{
    "v", ",", "t1aD", ",", "t2aD", ",", "vH1aD", ",", "vS1aD", ",", "vH2aD", 
     ",", "vS2aD"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qRoom", " ", 
      RowBox[{"actTauD", "[", "v", "]"}]}], ",", 
     RowBox[{"qZF", " ", 
      RowBox[{"actTauD", "[", "v", "]"}]}], ",", 
     RowBox[{"actTauD", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", 
     RowBox[{"-", "20"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "80"}], ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.5176737490670013`*^9, 3.517673751162981*^9}, {
   3.517675521661262*^9, 3.5176755221233187`*^9}, 3.5177525872149343`*^9, {
   3.51776570268845*^9, 3.5177657213121233`*^9}, {3.5177785777656517`*^9, 
   3.517778728420285*^9}, {3.517778901261119*^9, 3.517778951165303*^9}, {
   3.517779001065216*^9, 3.517779003759387*^9}, {3.517779155102839*^9, 
   3.5177791642698927`*^9}, {3.517779310373632*^9, 3.5177793531499367`*^9}, {
   3.517831657370152*^9, 3.517831702016336*^9}, {3.5178317373228407`*^9, 
   3.517831788714677*^9}, {3.517832304339867*^9, 3.517832344394607*^9}, {
   3.517838506148687*^9, 3.5178385372049627`*^9}, {3.5178387405443697`*^9, 
   3.517838857067531*^9}, {3.517838899062524*^9, 3.517838951249145*^9}, {
   3.517838994376738*^9, 3.517839023256781*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nk8VO0XAPDR3FuWyhIlUSpLUZGmQeg+hGjm3hkmtKlIb+qVktCqVEq0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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV13lcDe0XAPBIlEJShLRpQUVy25ejRVruzL2KNpJWW4vqfQsl+1siilAk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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1nk4VV0XAHAy3XNIpkrSYErRoLpE6GxDIvece3ORoTmViojiNTRTCKV8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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-80, 0},
  PlotLabel->FormBox[
   "\"activation time constant for D at 25, 23, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385272717*^9, 3.51844003316711*^9, 
  3.518642333748837*^9, 3.518702888713262*^9, 3.549977804428537*^9, 
  3.552325750281866*^9, 3.552326804614839*^9, 3.552396658762936*^9, 
  3.552417195324045*^9, 3.552417248510903*^9, 3.552419092353815*^9, 
  3.552573959475688*^9, 3.5525741106124363`*^9, 3.552583873939337*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["inactivation time constant (fixed, voltage-independent)", \
"Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}, {
   3.513458793285729*^9, 3.513458804092909*^9}, {3.513458868600246*^9, 
   3.513458868679677*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"inactTauD", "[", "v_", "]"}], ":=", "100"}], ";"}], 
  "\[IndentingNewLine]", " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10iD", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempD", ",", "tempRoom", ",", "Q10iD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempD", ",", "tempZF", ",", "Q10iD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<D current inactivation time constant at \>\"", ",", "tempRoom", ",", 
   "\"\< and \>\"", ",", "tempZF", ",", "\"\< deg C: \>\"", ",", 
   RowBox[{"N", "[", 
    RowBox[{"qRoom", " ", 
     RowBox[{"inactTauD", "[", "0", "]"}]}], "]"}], ",", "\"\< ms, \>\"", ",", 
   RowBox[{"N", "[", 
    RowBox[{"qZF", " ", 
     RowBox[{"inactTauD", "[", "0", "]"}]}], "]"}], ",", "\"\< ms\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.513458809322195*^9, 3.513458823438694*^9}, 
   3.514221884474872*^9, 3.515527886583037*^9, 3.5155283540584784`*^9, {
   3.517670819926249*^9, 3.517671043426475*^9}, {3.517671575497959*^9, 
   3.517671598625228*^9}, {3.517672757026401*^9, 3.517672824771913*^9}, {
   3.5176728628945293`*^9, 3.517672902982135*^9}, 3.517752640054345*^9, {
   3.552573942332781*^9, 3.552573953449823*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"D current inactivation time constant at \"\>", 
   "\[InvisibleSpace]", "25", "\[InvisibleSpace]", "\<\" and \"\>", 
   "\[InvisibleSpace]", "41", "\[InvisibleSpace]", "\<\" deg C: \"\>", 
   "\[InvisibleSpace]", "80.27415617602307`", 
   "\[InvisibleSpace]", "\<\" ms, \"\>", "\[InvisibleSpace]", 
   "13.84145488461686`", "\[InvisibleSpace]", "\<\" ms\"\>"}],
  SequenceForm[
  "D current inactivation time constant at ", 25, " and ", 41, " deg C: ", 
   80.27415617602307, " ms, ", 13.84145488461686, " ms"],
  Editable->False]], "Print",
 CellChangeTimes->{3.518364385303447*^9, 3.518440033196883*^9, 
  3.518642333770653*^9, 3.518702888743114*^9, 3.5499778044548407`*^9, 
  3.5523257503127527`*^9, 3.5523268046540413`*^9, 3.552396658800044*^9, 
  3.5524171953554296`*^9, 3.552417248563136*^9, 3.552419092382402*^9, 
  3.5525739595123253`*^9, 3.552574110662764*^9, 3.552583873976672*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kv? ( very slowly inactivating K current) -- K2", "Subsection",
 CellChangeTimes->{{3.513452858845728*^9, 3.5134528756218567`*^9}, {
   3.5134585153303213`*^9, 3.513458523488674*^9}, 3.513511323861285*^9, {
   3.514221824200597*^9, 3.5142218276549187`*^9}, {3.515527219395811*^9, 
   3.515527265421051*^9}, {3.517151406927*^9, 3.517151421045446*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaK2", "=", 
    RowBox[{"-", "45"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaK2", "=", 
    RowBox[{"-", "12"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nK2", "=", "4"}], ";"}], "              ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfK2", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaK2", ",", "vSaK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mK2 (black) and mK2^\>\"", "<>", 
    RowBox[{"ToString", "[", "nK2", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfK2", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfK2", "[", "v", "]"}], "^", "nK2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513452925247727*^9, 3.5134529662270327`*^9}, {
   3.513453012180917*^9, 3.5134531007944183`*^9}, {3.51345855907742*^9, 
   3.513458571445122*^9}, 3.513458664753249*^9, {3.513458697234359*^9, 
   3.5134587066976843`*^9}, {3.514221852792184*^9, 3.5142218558160963`*^9}, {
   3.515345225181307*^9, 3.515345228351499*^9}, {3.5155275514684887`*^9, 
   3.5155276031828213`*^9}, {3.515528094411598*^9, 3.515528118508649*^9}, {
   3.517151448878767*^9, 3.51715146071166*^9}, {3.5171516807348747`*^9, 
   3.517151702837295*^9}, {3.51715355731498*^9, 3.517153565970416*^9}, {
   3.517685515343185*^9, 3.517685515443975*^9}, 3.517779248041788*^9, {
   3.517839971056192*^9, 3.517839971159137*^9}, {3.517840032258606*^9, 
   3.5178400323694363`*^9}, {3.5178402033135757`*^9, 3.517840204912755*^9}, {
   3.5179268617199783`*^9, 3.517926861807132*^9}, {3.517927061288715*^9, 
   3.517927061391767*^9}, {3.517936267015091*^9, 3.517936267116555*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwVx3k41HkcwHFt8nTQmi6aRjmLnDO/qFyfrynXDIXZzWLXY1Wuspmm9Ow6
nkVJpPRUspXQWmSMdCPlazSONCXH6JAxNpRjfspTGBr72z/ez/t5GYUfCtj/
nYaGhi/V/6+sipuan+fhzM9OZTe9yiFOx+b3JWoeVpZwP2kGlQMzZlS1Yo6H
lz4I7dwbXQ53TSLUZtM8TLaGxbtmlkNtbsginwkeDh+dEEc+KwdJosfKvH4e
Lu2p7DoTIIReL4atXQMP/7JAZ2NARAUsUzRHhKXy8F63P0BaUQkmBQfrbVUB
2DVuCSeYfhuWlc6mLUoIwLrsdEdD/Xuwohb1Ban98WTiDH/6SDV0B3caGRzz
x/p1a2YK/66DKHe/l0PTfvhQh6CNzMJw/xE9ZkOcH37la6Hr6d0InqkOTFHn
bjwYqOqh/dAEjQztCPPXu/A6T0n7bHIr3O9IjE1p9cVXixSFZT5S4DDEPsNt
PvgSU641m9cOjERBIKeTi985PTSV3uiAfVP1W7IkHDy5TTVnQOsGXy3Fx1et
3rjrKaO8iN8DIrt8vmaNFzazXWr4yOQNcPkSU2uRJz7yIsw8Vt4Lme7im+F3
PHDE3YPr5uLlAPbBOvHF7pj1QXptm6kCLlY3sXNLd+Jw7GQ4FTcA4YHPORcu
7sClexo36Lf/C7Ha7OSzGWy8h7/KrYI+CPo/Zp66lO2Gc/qv3plxHQLHmtjI
pCSE/XIqT8ZHDsPMr1zHfrUrrpIH/uwd+QFmks7P1Wu74BDJ6fSjvh9huJ22
L2TCEadULKS32I6AHnd7gu70NhwnUBSEjo+A/Vzu1pRuB2ypwRcQxaPw/PUz
zljdFpwfPO9rwB6Dsj6hDr+FhUUFWmNnGscgjt5w9NYNO+x29LDMwnUcvqjU
dL1Qa/zHcpXBqaJx0KBbTdcnWuCEMWOTXV/HYbhEsqHfwwxHbDXrfuCuBP/U
WyVEkBGW1C/iR59Qgs2llRNz1nTsc16mew4rATdF+c9sX4EfQvrhalIJCX4u
jMdvNXFv3ta6cD0SLANlKvssef2oecsHXWcSvBYkIY+qKejJFm2yCiLh8aqN
sheT2qj/Jcd7QkDCn8YlI13yNcji6acK/UwSLudfsAy5tx59ztZyuH6FhOT1
3Qdm/jJB/mvFtY+FJFQUZA/Qzm1CD8au9cRXk/C++aLQ/oglUiutBlc1koBS
mZsHhLaIlnEnWvaMBJ1jj4pFUibKeecizugiwfl00Xi8jImcvKWhZZRjik44
IDkT1Uclv2+m3NLm29IxwUQjNieFWt0kpBr2jU6tZCHSS2WRRnm6Vc1iB7OQ
+fdJX4/JSBhgoAbZEAuJDoQ6+78igcYyXVpIshCxWYPxG2XkuZgXPc1Cgrs1
Q5mU8/nt72eXEMhOv8rlCeWfmsIWG1kTSLiTO2n/mgTpoZTdBwQEKmIbZ65+
Q8Lc8f15WxIJlNdqZ8ykvPmyt+LbcQJ9Wc0u8aGc8YQmyMklUOCeksNplNlr
r+feqyHQ1D+a6yco823S5cliAu19Ua237C0JhTtizL3aCLQ8SvHNjPK3WFbt
m14CXVE3nw2hbJW2ZmHxIIGyyCKneMrBeSpurJJA/fbmXTmUT4n6LjhMEejs
7aggIeVqsfjd/DyBGpz5bRLK/wF/M3XF
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV0Xc4FYwXB3AkETJLJA2SWbgh656bce91ubt4o0SRSrYSyWtkVCK9oUFG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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mK2 (black) and mK2^4 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385335149*^9, 3.518440033230431*^9, 
  3.5186423338107033`*^9, 3.5187028888357162`*^9, 3.549977804490576*^9, 
  3.552325750347518*^9, 3.552326804706599*^9, 3.5523966588519487`*^9, 
  3.552417195410327*^9, 3.552417248601565*^9, 3.552419092433913*^9, 
  3.552574019341905*^9, 3.552574110712759*^9, 3.5525838740267*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"xInf", "[", 
       RowBox[{"v", ",", "vHaK2", ",", 
        RowBox[{"-", "11"}]}], "]"}], "^", "nK2"}], ",", 
     RowBox[{
      RowBox[{"xInf", "[", 
       RowBox[{"v", ",", "vHaK2", ",", 
        RowBox[{"-", "15"}]}], "]"}], "^", "nK2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.517840127565958*^9, 3.517840167605942*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwV1nk0lV8XB3BDRUlUypAoQ4RMNyQ8+4m4pssdDCVFokQiRCFFKDL1y1BK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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVjnc41Y0bxiVJpbIrmYnXXicj1PNFzjkOx1lGIY0XFdlKAyGaHJGVUoho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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mK2 (black) and mK2^4 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385373081*^9, 3.5184400332625427`*^9, 
  3.518642333839164*^9, 3.518702888862404*^9, 3.549977804527529*^9, 
  3.55232575038083*^9, 3.552326804756352*^9, 3.552396658996505*^9, 
  3.552417195457481*^9, 3.552417248650099*^9, 3.552419092487658*^9, 
  3.5525740194820232`*^9, 3.552574110762177*^9, 3.5525838740778933`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["steady-state inactivation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513458864673243*^9, 3.513458864735363*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHiK2", "=", 
    RowBox[{"-", "60"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "inactivation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSiK2", "=", "10"}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"inactivation", " ", "slope", " ", "factor"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"inactInfK2", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHiK2", ",", "vSiK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{
   "\"\<steady-state K2 inactivation (blue)\\nplotted with activation (mK2^\>\
\"", "<>", 
    RowBox[{"ToString", "[", "nK2", "]"}], "<>", "\"\<, red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"actInfK2", "[", "v", "]"}], "^", "nK2"}], ",", 
     RowBox[{"inactInfK2", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513453111003118*^9, 3.513453181572648*^9}, 
   3.513457942308256*^9, {3.513458725101942*^9, 3.5134587297227297`*^9}, {
   3.513458905403673*^9, 3.513458924814267*^9}, {3.514221893812447*^9, 
   3.514221897020445*^9}, 3.514221930376923*^9, {3.515527956434649*^9, 
   3.5155279570667553`*^9}, {3.515528177384358*^9, 3.515528203743281*^9}, {
   3.5171514696994133`*^9, 3.517151478410677*^9}, {3.517153537322022*^9, 
   3.5171535448095703`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV0Xc4FYwXB3AkETJLJA2SWbgh656bce91ubt4o0SRSrYSyWtkVCK9oUFG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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVkmc8Fez/gAmVUBll5LFlheMcjpnvLeukbBFHiSh7pMgqO46UrPCjkCiy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state K2 inactivation (blue)\\nplotted with activation (mK2^4, \
red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385403183*^9, 3.518440033351256*^9, 
  3.518642333872342*^9, 3.51870288889529*^9, 3.549977804558655*^9, 
  3.552325750417347*^9, 3.552326804818205*^9, 3.552396659033267*^9, 
  3.552417195491107*^9, 3.55241724869429*^9, 3.552419092536819*^9, 
  3.552574019512833*^9, 3.55257411081413*^9, 3.5525838741272163`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1aK2", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2aK2", "=", "120"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH1aK2", "=", 
   RowBox[{"-", "40"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1aK2", "=", "8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2aK2", "=", 
   RowBox[{"-", "70"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vS2aK2", "=", 
    RowBox[{"-", "20"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tempK2", "=", "23"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", " ",
     "kinetics", " ", "apply"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10aK2", "=", "3"}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempK2", ",", "tempRoom", ",", "Q10aK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempK2", ",", "tempZF", ",", "Q10aK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<activation time constant for K2 at \>\"", "<>", 
    RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
    RowBox[{"ToString", "[", "tempK2", "]"}], "<>", "\"\<, and \>\"", "<>", 
    RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"actTauK2", "[", "v_", "]"}], ":=", 
   RowBox[{"xTau", "[", 
    RowBox[{
    "v", ",", "t1aK2", ",", "t2aK2", ",", "vH1aK2", ",", "vS1aK2", ",", 
     "vH2aK2", ",", "vS2aK2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"qRoom", " ", 
      RowBox[{"actTauK2", "[", "v", "]"}]}], ",", 
     RowBox[{"qZF", " ", 
      RowBox[{"actTauK2", "[", "v", "]"}]}], ",", 
     RowBox[{"actTauK2", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.5176737490670013`*^9, 3.517673751162981*^9}, {
   3.517675521661262*^9, 3.5176755221233187`*^9}, 3.5177525872149343`*^9, {
   3.51776570268845*^9, 3.5177657213121233`*^9}, {3.5177785777656517`*^9, 
   3.517778728420285*^9}, {3.517778901261119*^9, 3.517778951165303*^9}, {
   3.517779001065216*^9, 3.517779003759387*^9}, {3.517779155102839*^9, 
   3.5177791642698927`*^9}, {3.517779310373632*^9, 3.5177793531499367`*^9}, {
   3.517831657370152*^9, 3.517831702016336*^9}, {3.5178317373228407`*^9, 
   3.517831788714677*^9}, {3.517832304339867*^9, 3.517832344394607*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nc4V+8bB3Cz7J1N9t5KMnpu++NzDipFIakoKaOlshJRkYYyKkkqvgoZ
pUI8FJKdEZWdUSKj7PE7v7/O9bquc/4493g/j+xB/51eTAwMDCWMDAz/f+bm
BcytrTniMquqUCcLcwjg1jrPvuqIK0POq6TbmIOuz9iiwLIj3sC9QXCCMIeX
8odXFecdcZuEYEb0LnMoTnRlJScdcYLy9VfFXuZQFWItmNzniNn2B3NpXTGH
7zRJbZ0KR7xr71+RbQ3mwNlfc9gjwhHri/EfG3a2APmHx8u1F3fi9uHx8Noo
S+DMXIpkDd6JX52OqfqeagUCxdCzd3UHfqQ+MfUk1xraXVplpc7uwGJM5t7Q
YAPeVttbhue3Y5VGm8n/6mlQ9E7cZ2PAdtyv3Hg2ttEWbCIMdHNaHXBM07vU
lnw65HWyS79vcsDixiq0kZd0ENfu5uiqc8CDgpFSS6/pMPEt8gfLBwfMzKRh
JVVGh8TNLUluLx3wiBH7HuITHYZHj61yJjjg4zYy6+0G6BDl8KjOx8kB/06Q
MfzKR8DE09Nvwnc64JtFSsv5ggTsWbZ5mmjvgC8p3C68LEyARtZEWKW1A67/
vvufhiQBbUwmeuJbHLCSz+5b7soEKBR1JNeKOGCe7fI33EwJeC/JdVilyx67
X8tOLDpCwL1e1U8/2+zxQJ7c03AfAk6m22g9b7bHEpNbWGi+BMipRM5qfrTH
M5dOPms8SUCE/mK0/mt7vLPHYWdJKAFAH83clmCPWbaeGeK9TUDp2Q8/d+2w
x8ZsD2/dKSHgjtGAnbCdPe5UGO5jLiPg+Mpa/heaPc4vOaYTgAmQiDQOcgF7
PKj1owpVERB0vYDDQ9seW7PoRxQ3ErD1aZr6MW577BVwa1Gin4CizyG+F2vt
8GnfJ9dDmEn4PrLAEltlh78y25t6spLAtBKYcqfCDh81KWS1XU+Cg/KJusy3
dlh4bvYrOycJo8Feqo1ZdlgtXtfFW4AECUX7IfEYO8z0RREnypBgblQXohBt
hxXacpgd5EjwdqAJaUXYYZPfDaYsCiS8PG9uYRZkh09uXb7mpUyCfaPBoyM+
dpg1mmEvsxYJ4Wc37ntJt8PF0a9fZRmRkHEt5e87azuc0muzR8eEhPpHYtdq
zO1w6lp7Q6EpCWL1giVfjezw/b1zKvlAQoEMmxijuh32L4/ziLImYah2ss2O
0w4bfF/ovrWDBK5e3+PO6+1w0JTk4x87SdD7+4v5ALMdDv5AE9m0i4Qw6SG9
00skDpovZK51IkH0VNfNe2MkLmROzfnkSgJdspIcqSMxubydUPciobb/dyfL
RxL32bR4mB8mgZYp4iX3gcRMj/LlnY6QYKPnG7qvlMRae9iyTh0lwZImmtua
TWLeoxaB0b4kvOe2MJr6j8SH7BeLI/yo+rX6VvM8pd5PX7of7E+Cmfv7HtsH
JL6GdqodOkHCttN+vDiOxBY3w03Yz5Dwbuvd+91XSZxkU6r8i7LJ2nvlpSgS
tzpopNYEkmAcIwYGYSROUd6ocO4cCYZpHwKy/Ujslx6350UwCfr14p+THUi8
j6E36vRFqn63rNyLCBJ7ZhxVkIqg6uMc8KvVhsS7g3k0KinrDFQx8QKJ588p
+TFeIkFrPkA/SofE0S6SEbuiSch5d788XYPEjlHMWn2UNSKrCaxCYhNHTj3v
yySo80h6LsmQWD6X1cj3CgkqCjV3TvCTWMEjkIeIISHz55TMDW4SZ4TowlvK
Si8kc7LZSSyuqPJWPpYERaOTVSOMJB4bdjs3TvnJWsoO1lUCy5w/XExeI0Gh
qqZbbpHyDXPj/yjLbZea3TdN4DxdninHOBIebaBFBE8QWHyoXvYJZZlvJ3nu
/iKwc8DylUnKaWkP7hUNE9gsI0ph63USNh7+qNQ2QODNvTumQymnqs8UTPUQ
2GKZPllGWXpKCvF+I7C3j6vkMmXJkFPO9FYCt5T6zfrcIIE9d9RFsInAiacT
nqdRnu3d5/79E4GjlSO+tFAe5G898JQq0WXZG2dXKTdb0Lz8Kgl89prIVaWb
VH/PvPPeUkZgdOYsO53ys0y94wzFBP7azDnrTTm5K9O/9hWB/S7qkZGUozil
TsXnEzjQlc5+l/JJ0/hA1xwCt6sVqj2j7OG/Pkghi8D8bxpyiijbPQoJHX9C
4JiGpRtllI1ap8KL0gj81CStsYKyMuuRSxdSCCw1KH0EUxba8v0yLZnAdnnf
nYopMx7dEct/h8Dhz9D9F5Qn7lVf/3qDqt/fXN00yt/qjeMfxxK4riVe5Brl
j6t5CccvE9gzdxf9FOVXOkp3N0cSuFF2f81uyukH76eshhH4wz+pa/qUb9zh
S6sJIvBR9dUELsoh1VGPbwYSuIfBb6CPqpfP/GLG3pMELpn97pdH2Vkt4Jmc
H9Xv9hLDYMqWbkM5Y0cJzPsyxNSMst51l/yXXgS+uBQfxER5I256GXqAwCl+
p8b/30+uacs31vsInKx153Yg5QX54hLevQRmqjjuo0p5eLd2eecuAkdtCPT/
Qs0LfitW7UMS+MA866IC5Zyx67X6NAIfyY4K+kDN3z0ploZlCwLHn1fZuJ/y
6YsTrdeNCXx1+9dPUdT8Hig89MV5C4Gvv52o56dsP9T5VUafwBzrdH8mU/Ov
avu+v0CNwFDgejj5KgnCwYZDwUoErvd2quSjzJKTM2opR+DI0sdal6h96uFL
/tMhRuDSFF8tN2rf4juPryyyEVg040l0M7WvFzgGGD6wEPh9O4+sLOXjJs4s
cQwEps96vzkeSYJ1mhnnxnk6Xpl3b/tL5cHSEWExixE6bjLqDvsYRuX/3VhJ
rkE6vjFnWTYZSkJHHYNMew8du2i9HBGknKc9pnSkg46tOl3/0Kl88Zwr3xRb
Rcf9rzRuBZ+l9iv4zrGUCjrmFI0yuEbl07c17/Scd3ScX+vvnkzl1042Ab7m
V9T3FRlaj09R+SfmOSaUQce7G7IeRFB5KG3Mlp4aTcfqrdcUjlB561L+vfNF
BB1fSe8Q16byOMEin7cijI4tXDafnT5E9ZN0CR0MpOOTvU6uxw5Q/+OWvUfl
CB3HcT99pOhGQmfYdt4CGzr+U+6cX7ydmm9mRev3FnQsPVOODB2o8+/yQkgb
ouPNIo1i+XYkVN9I/zW7hY69OW8+u0On5jftb5WxCh0HRksKyltS9a5MDqli
o+NpCdZsVwNqv9b1/+ystcUm31YGdEWo/Z9dS0qossVJh/aHjApR9RiRtt5Z
YYsbglT33qXO05mPbul1b2xxhVhux09uEu7GdrqUZdpizzavIisW6jzja657
HGWLbWV1y0b+EHCd8c95j4u2mEvrzFezcQIMp7lVpEJtMcueWbnEXwTEthKX
Ek/b4qyQSH3NIQJ0E2tMrh6yxYHX72lv+EpAqER5jp+ZLd7roRhTV0mAEleP
q7qpLVY4tNBZU05A8/Iy+6ihLda6EGtWVkqAfI/R4QM6tpgYW3C9W0RAbVqR
9K6Ntlii4PZ9tmcEbFDKvbF1hYY1e9siP90gIEfnwQmWtzR87FIWxxcnAvJa
jgq1v6Rhuvful0qOBBScNHj9NI+G7ZHRvQAH6n7ysmnZ+j8ajj+ULjZjQwA2
ZLpyNYmGT2t09BUYUvczOJLKE0jDXetlT0mJEbC8XbdOVJ+GN2ZaTqe202F1
asX3pxYNy+kL8Rm00IHx9ie+YjUaZhji8q2pp8O69kNOrnI0XL0tcLjzPR34
9ib2P+Cn4dDY88NF1H1U4cDSnNykDb64S+n5/mt0IE5UKWjm2OCDnhJyPqZ0
SPGcWrTKssEpnl3Kjw3p8NtZqsX9qQ0mNhFWX/TpcH3bmdCbD2xwBdeDOh01
OnzmVOyYibPB9SWeilnCdHDJuHS52M8G55ywEs+bsAWfbxa/bHRs8Dd+9ysy
920hxqryxcFCaxzWH7X15xANbJ8arii9sMbrL0S2nOylARvrC/rYM2ts5dSt
NNdJg6gP94dOpVvjmjIJ4ck6GoRbnJGIumWNj9Q83v84nwZnzVQuZ/pbYy+d
K2ECITTwNL3u/lvdGueHrQ9Q56YB2uzCHfjECl8Wc1JWkLWBhDfV5omZltg3
4fFSu4kVHHRupN9JsMCXXVRudjFagC+XediNK+a4LXZokFYCILo75mpSnBlW
1Vzdo2tqCkZvfY+EhgK+wxi1zumrISwcIIz6Vrfh7uHJzCrezbAQenu5nMsU
h56Oa0x8qQsjzfyerpNGmOZursrKqgkixNZgvnlDbFD1UoRjRBm+V6hti/5j
iI9/Zil+8FkZ0gwlGZeHDbHKYDMvlCmDitJa9Ei7IebZFvg+L0EZjBir4ssK
DXGd1WKNmZUyuL/e/uy4vyH+fOskj3SmEmTIe3d9HN6C79U8Xbh/RhE2Lydu
udhugP1EjA8FmshDduvgoHSDARZ5sqz8XV0e5J7r3Cz9YIAha7jMXkIeeFw+
jc4VGuCCA+N0l0U5GH29ctcv3gAf0h7W4XgrBymnPJddHQxwznmF5hpDOWAa
060wqN2MD9b2BF43k4XGrnr679JNONA2irdiXBoGdnfuE3+1CaduYt7u1SYN
/1oGA2g5m3BXv5iAVIk0SH5aTHzyYBN2S0/9U31FGo4Wqwy6hW3CmXsf9DIp
SgPL/UvBDWgTrlpu4RI4IAXGbibZuZX6mMO13tJsRAL+63nOfeKjHk6tDroS
rioGSfok72y5HlbM7ZaYEBCD6Cu/+YJf62ENye3H/ZdFwVNPUygqQw/fH4jl
zmkSBdnoXPG7l/Rw4IDAZ4GzonBPM1+5AvTwwxc3T4bUisC1kCIz/re6uPfk
kc1HQ4QhQLziTH6WDj5weDWsTEQIlgVleqof6eAzLNOeP9YJwRXuC9bf7+pg
tcOX7ovOCkIag6nI+hgdHG5BtjxvE4SW4Tdv3Hx0cIrLOxQSLwh6hXlL69V1
8FUff8NSPkH4lQTM7/ZoY9Mu96UTIgLwb3FVXMRdE89kppy/TvDByRenym7Z
a+JpfZkT27bxwcSh0QNcSBMnfqltWdDhg+H6lv8YZTQx63mm7HhhPuhIfWLw
u18DC804ZyR94IU35vSdFV4a2GPh7eh/czwQFJNw9ZivOh6yUPBk8+MGBnGN
+fIQVezrvfWcRjIHbAr/dG70mCreFOrz+nc4BxwZ9l7gc1XFA+d7BN4f5YDG
gqeLB7aq4lVp8c/5xhzwgNi4wjyrgjMMQvcl9LGDUagAE81fBRfys2h7arHD
6b55zuYDylgsaDHhYdd6GMmo2thnrYh/VQr25fiwwi6nfl/VLYpYMLnn2sO9
rFDJulJyUlkRJ8x7ZKbRWCHVc9MeVjZF3LTh8VSzEvW+3OObarUKeLf7uxOj
gyxQ+SCc8QyhgJ2zLWZGPFgg5Y7xIPt2efxT86BfixczcFg66zqCPC7p+rAn
2YkZzs6cvJCiI4+fT7XJ+doww86dzyS0+eWxV8pNJVBlBnY+sV27PsvhRmmv
9JhxJgiMnf2QuksOM/8+uyXzHBPsiMjP0N8ri5cm0xZykxkhcHC2RY0mi42L
903PXWWEFEuTFdktsnhU2yrOIZgRhtfVOPJtkMXPg++eVHNnhKDY7wzjzTK4
un8+JE6BEdLvrHfNoMngQIOUyuVCBhi1K5HWC5DGp9xUW22K15Aen/UZGXtp
fO7CsUL7tDUU8rm5jkdDGicEvo/3j15D/M7D58ZGpDDT55Kx1Z1ryMiDv/XJ
finMqZPitGN8FcWePHJZxEESNxtsbX2htIq0kgQnlzXFcfqLX8U5z5fR77Hk
fg0ecXx34l+BbeIyegbSrW4TYljTcqF6IXwZKf9SKSrNFcMKQ/GLCU7LSMZ0
W0iIthguZl9ILmVaRgKD3mzLOqK4b+u4aqH7EprTKpNZ0hfGZvez7OoVFhGu
9t6xsFUAe0h48goMzyHrVNfRj+ICWGchSelS+xyqP2N/IXmJH+9N9X7MWjWH
OhU25Wx5x49lRZMSDZ7MocmINbZA4Mf057kD9ofmkAxKxNPWfPjqk2B9ux+z
aNXv8v7OTC4czmcsqDD1D3FI+8adPcqFD33O+e098A8JN+wsEVbnwlmsQ9El
rf+Qlrq0yO5cTnxYqb/uatE/tG/kZWPLSw7896HsttqQf6h0/4BpXQUb3vE3
UbiW8x8K3m4qWfaNBTPN1tPO6/9FntW1ZULJLHhbNdNeC8W/yN7E6cCxXSz4
UcuOLgmRv0hOxT9DtIEZ74k1nJpbnEEf19J0TpUxYRXLpSmX9zNI+AWLlcoj
BpzNIsiInWaQh0TyN4WG+XIPMKZlXp5G+uvzZT5bzZdvql8rVAieRutmar0u
lM2Vi4Tt68v1m0Y5n5b+dL2YLRfV3kL7uXsaLZ7fz3Ij/m/5799Wf/8qTKOE
TiXNBefJ8iS10kG3qimk7tyxuDm2tzxuy848cd4pVKw5WMYS313OO/xRvI1l
CtFYJiNak7+VX/j+yjFpcRIdzmfnPJHxpfx73D4u4+FJZCkSZLAnsqlcze7u
vdl3k4ghdS2A/yxCsW5jOw38J9Fix/XIqXu9KDi3Utkg/w8yYKjYz/+pD/2Z
anJeTP2DJu4Ur2RV96N+vtyFpmt/kEdZztZv5YNo677gHS+8/yBz/jv5pgUj
6GjRSIyJ7B+07rXHI6akP8gtxVQ2MmEC0RhDwTpvDnlaDD1zjBlHP001MuS3
zqPfruc+NZwbRzFB3zgZK+fR0tVCaZcj46huZuuXktYFlHdgSDzLchzZD8/6
6s4tIe7mWHdphnH0zOuNHc9GBjCYLtdxCvqN8ul6wQteLBCzW+76heAxxPST
Xcv7GQus3LNMlTo+hnZe7u/rmGAB04z2gjq3MTT9/qb1y7OswJP2ItN52xja
ZPqH3//qOlAnK+c1mMbQG+3s/35kswFDF79u+bVfqExIqaNphgs+DdjNC+X8
RBdy5LatGXAD/f7k19aHPxFYb8zQCuKGX60uO9Lif6LKs6KBcQw8MFlbVnng
3E9U85VDmODmhYBEC+Moy5/Iu3lO7dBtPih9Xf7JvHcUBSR+9+nJFgBjw3M0
U+lR1DzwVTqwUQCufz4kmCAwinS1uz5zTwpARsvDtvl1o2i6pt3IVF8Q4nAq
+48/I+j0QiNHyltBQBK+4zaVI+icW8WzvdVCMLQxA4yPjqBwuYxfbb3CcC48
M+FC+TA6/j2LWX1NGGS5JEP/vBpGexNzJC9Ki4DSAu9N7+xhpMfxyl5znwjs
nSvZEHh3GA1OvS+I+ioCr2ybc1dODSPriv4gg3ZRECL2ZL5WG0bcHlKcyZ/E
4YB6QFVK6hBaFJNVmPgpDtusJXplE4fQcKuCqSW7BMiwE1Iv4oZQmY2G/6SN
BPicdhjtDxlCAdrGrbQqCXh9UXog03UIta3uub9QLglRmq+rcsWH0L0Hd9Rd
X0nD1aRMfDr1BxL9axmz+4s0DJZasNkn/kAJ9H+jDgvSwLSnvVH7+g90c253
hqXpRkhjb3rFFfYDXd4hIqtVtRGeKdbMqbn/QMVMdrHhPjKgI/SlYWrjD5RR
1BTuGCQLp/4G3/bLGkRD/cp522Nl4eUra0+b9EGkwB3ea5ciCweT1mUr3x9E
jw7pbKOVyUJFQ+zF1WuDKIXv1pIJkxy8YvT1YzkxiOJ9dgYqxcjBHPNMkY/R
IAqTbj+2cFce6hwqP/l+HkCRDHkN7VnyIHb9WcKt+gF0ZSBGu+CtPMyfZhAt
qR5AtzJgxqdLHjiSvmpsLBlAT7Syg76LKsARgZcrak8G0KdtkVfLkxQgzdU7
nDw7gDbs182MSlAE0b0rW+JlB5C4GRf7waeKMBtVmnJQcgBJy4/4bHulCDfC
qvkNRQaQykiK1lybIrDZSItNcw0gI3+2Im8hJShyuy+UPt+PPC70fiBuK8GG
n6Ox4839KPth3AD/LWWIbuP9zB/Vj+xw/onUNGVIF86Wjw/vRxN97Qzqecow
HFzwQTikH+nISW+0bFIGwbd3f2ic6keFT3JdA7lV4ML5cdVrB/pRcVZT29er
KrA3cMVGEPWjj4X8NY8jVCEJ+V1QWelDR9s2O+nEq8K6t1+E1Bf6EMe/vUOl
j1ShvTM9VPdfHyIN0pk7sCow19UX2473oaY3esC2pgqcpwzCMrv7UMc7x7fH
g9Vge3ohx4byPvSjJuH55tPqcBdypx9e6kONBjf3CUWpg1MA3bU2vA+9fhrD
O5OgDkxfnlfOhvShmMgLp/Jeq4NNh2HovjN9SAcdNVZfUoecpgotl8N9KLjI
pE4mQgPesvgtcdn2IYGng784b2qCfPizJhP+PrQs2JPyK00TBmTY3Xu4+9BQ
RKd9bb4mdCd88Ivk6ENvPBoKols1oTDqE1sncx9yl3wdxCiiBc/X7Tu9e7wX
Zd2O4Zh7oAWlIlcmht72IojQVRt4rg2xl71Dxp170WRmLk9aiTZwzXzO897Z
ix42qM/sq9OGhoqbFj/JXrQqqlTa9UsbdguY+y+a9aIeZ+7MUSEd6MrUc3DT
6EX3Jxi39jnqAHeHfLkYUy8Slhxza2rRAeKkzKc9+T1oIlfVIbdLB97cjt4Q
mN2Dqs28zeL6deCJtbVccmYPOnNkSJGY0oHVUm/fXw96UFtB70Q1ny7UP7Oj
18T0oHjbtvAyB10I2hyt6e7Vg7jPvnuS06ALDX/WJvulepDJtUfjgR260KW0
ewePWA/yeRRlAL26EPIybRIJ9aCPdXYfP0/qQsYvn/YCjh4UIdMzNieoB+qV
2+91zHWj+dpVPXMXPUAmhlv5W7vRgCRUdAzrQeYKt6lmXDfi11PgSPujBz6z
tROzV7oR2LA5Hp3XgzkXxc1Vl7rRgxPNP5bY9YEnZ/iYf0g32lPtwSarqQ/l
ZjNzC8e6UYP/RYdjp/QhaOSY/SDRjZYveSVvCtGHDR2bmf7adCO1e7b9K5f0
oTr9xQqbZTe68oH/1M1EfZhSU3uLTLqRuVh64qu3+jAzfqeiV6MbndCK7g2r
1IeH4UJ6AqrdKM3CR4VWpw/8boVVNMVutOKrV/z1uz4cyjlkWSnVjTQihZmf
DOkDy+1YJVbxbuSSvEj4TuhDVuKaGCncja7m9NwxmNOHj6NO4kkC3ehNZWX3
2po+hAVpyg/zdKP/AXvaHqA=
     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV13c8le8bB3BEmYVkZZ5D9haldN8h6xwUSWiQJEpGpTLKiERJQkhFhYYR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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV13c81d8fB3CzzMysZO89ShKdt5Fx78W9NElRKcnKqiRkRqUSUpGR0SJS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"activation time constant for K2 at 25, 23, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385452629*^9, 3.5184400334015913`*^9, 
  3.518642333934393*^9, 3.5187028889561253`*^9, 3.549977804607633*^9, 
  3.552325750468979*^9, 3.552326804861805*^9, 3.552396659080883*^9, 
  3.5524171955425034`*^9, 3.5524172487362633`*^9, 3.552419092583343*^9, 
  3.552574019563837*^9, 3.552574110860998*^9, 3.552583874315358*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["inactivation time constant (fixed, voltage-independent)", \
"Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}, {
   3.513458793285729*^9, 3.513458804092909*^9}, {3.513458868600246*^9, 
   3.513458868679677*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"inactTauK2", "[", "v_", "]"}], ":=", "8000"}], ";"}], 
  "\[IndentingNewLine]", " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10iK2", "=", "3"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qRoom", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempK2", ",", "tempRoom", ",", "Q10iK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qZF", "=", 
   RowBox[{"TempAdjust", "[", 
    RowBox[{"tempK2", ",", "tempZF", ",", "Q10iK2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<K2 current inactivation time constant at \>\"", ",", "tempRoom", ",", 
   "\"\< and \>\"", ",", "tempZF", ",", "\"\< deg C: \>\"", ",", 
   RowBox[{"N", "[", 
    RowBox[{"qRoom", " ", 
     RowBox[{"inactTauK2", "[", "0", "]"}]}], "]"}], ",", "\"\< ms, \>\"", 
   ",", 
   RowBox[{"N", "[", 
    RowBox[{"qZF", " ", 
     RowBox[{"inactTauK2", "[", "0", "]"}]}], "]"}], ",", "\"\< ms\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.513458809322195*^9, 3.513458823438694*^9}, 
   3.514221884474872*^9, 3.515527886583037*^9, 3.5155283540584784`*^9, {
   3.517670819926249*^9, 3.517671043426475*^9}, {3.517671575497959*^9, 
   3.517671598625228*^9}, {3.517672757026401*^9, 3.517672824771913*^9}, {
   3.5176730004919167`*^9, 3.517673108336378*^9}, {3.517673332171762*^9, 
   3.5176733646169357`*^9}, 3.5177526622471113`*^9, {3.517935652979268*^9, 
   3.517935680612846*^9}, {3.517935782153311*^9, 3.517935782736204*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"K2 current inactivation time constant at \"\>", 
   "\[InvisibleSpace]", "25", "\[InvisibleSpace]", "\<\" and \"\>", 
   "\[InvisibleSpace]", "41", "\[InvisibleSpace]", "\<\" deg C: \"\>", 
   "\[InvisibleSpace]", "6421.932494081846`", 
   "\[InvisibleSpace]", "\<\" ms, \"\>", "\[InvisibleSpace]", 
   "1107.3163907693486`", "\[InvisibleSpace]", "\<\" ms\"\>"}],
  SequenceForm[
  "K2 current inactivation time constant at ", 25, " and ", 41, " deg C: ", 
   6421.932494081846, " ms, ", 1107.3163907693486`, " ms"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5183643854866953`*^9, 3.518440033429923*^9, 3.518642333971333*^9, 
   3.518702888992671*^9, 3.549977804644858*^9, 3.552325750529619*^9, 
   3.552326804885688*^9, 3.552396659120613*^9, 3.552417195572221*^9, 
   3.552417248796234*^9, 3.5524190926249113`*^9, {3.5525740134033003`*^9, 
   3.552574019616297*^9}, 3.55257411091358*^9, 3.552583874342647*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["HCN -- H", "Subsection",
 CellChangeTimes->{{3.4717804882486897`*^9, 3.471780497533472*^9}, {
  3.487597040801697*^9, 3.487597042520385*^9}, {3.5155272957184887`*^9, 
  3.5155272974145203`*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, {
  3.487602443429934*^9, 3.4876024443724117`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaH", "=", 
    RowBox[{"-", "75"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaH", "=", "5.5"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"actInfH", "[", "v_", "]"}], ":=", 
  RowBox[{"xInf", "[", 
   RowBox[{"v", ",", "vHaH", ",", "vSaH"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", "\"\<HCN current: steady-state activation\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"actInfH", "[", "v", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "100"}], ",", 
     RowBox[{"-", "20"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "All"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.471780586933622*^9, 3.4717807557440557`*^9}, {
  3.4717808325536003`*^9, 3.471780921481627*^9}, {3.471781102068452*^9, 
  3.471781119883608*^9}, {3.487600985231902*^9, 3.487600989522131*^9}, {
  3.487601034271371*^9, 3.4876010568328123`*^9}, {3.487602456391823*^9, 
  3.487602469439934*^9}, {3.4876025042437153`*^9, 3.4876025051077833`*^9}, {
  3.488035791854258*^9, 3.488035792124054*^9}, {3.5153637579346247`*^9, 
  3.5153637580010033`*^9}, {3.5176842786236277`*^9, 3.517684283558695*^9}, {
  3.517685349588394*^9, 3.517685360413022*^9}, {3.517761723361795*^9, 
  3.517761723649267*^9}, {3.5177618623278313`*^9, 3.517761881264327*^9}, {
  3.517774381545134*^9, 3.517774387431234*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJwVlmk4FW4TxiUVKUv2QkrKnn1nOLZjP7ZzDpW9EFEiIiUiQvY1W7KHspR/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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-100., 0},
  PlotLabel->FormBox[
   "\"HCN current: steady-state activation\"", TraditionalForm],
  PlotRange->{{-100, -20}, {0, All}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{3.518364385519639*^9, 3.518440033447672*^9, 
  3.518642334006212*^9, 3.518702889027953*^9, 3.549977804694717*^9, 
  3.552325750564311*^9, 3.552326804924181*^9, 3.552396659169751*^9, 
  3.552417195626143*^9, 3.552417248828985*^9, 3.552419092672367*^9, 
  3.552574039817874*^9, 3.552574110962913*^9, 3.5525838743952103`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "based", " ", "on", " ", "Huguenard", " ", "and", " ", "McCormick", " ", 
    "1992"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t1aH", "=", "100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2aH", "=", "600"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH1aH", "=", 
     RowBox[{"-", "77"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS1aH", "=", 
     RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH2aH", "=", 
     RowBox[{"-", "52"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS2aH", "=", "12"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tempH", "=", "35"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", 
     " ", "kinetics", " ", "apply"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10aH", "=", "3"}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qRoom", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempH", ",", "tempRoom", ",", "Q10aH"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qZF", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempH", ",", "tempZF", ",", "Q10aH"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelStr", "=", 
     RowBox[{"\"\<activation time constant for H at \>\"", "<>", 
      RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
      RowBox[{"ToString", "[", "tempH", "]"}], "<>", "\"\<, and \>\"", "<>", 
      RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"actTauH", "[", "v_", "]"}], ":=", 
     RowBox[{"xTau", "[", 
      RowBox[{
      "v", ",", "t1aH", ",", "t2aH", ",", "vH1aH", ",", "vS1aH", ",", "vH2aH",
        ",", "vS2aH"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"qRoom", " ", 
        RowBox[{"actTauH", "[", "v", "]"}]}], ",", 
       RowBox[{"qZF", " ", 
        RowBox[{"actTauH", "[", "v", "]"}]}], ",", 
       RowBox[{"actTauH", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.517673518400874*^9, 3.517673538585085*^9}, {
   3.517673607224803*^9, 3.51767364434464*^9}, {3.517673684922886*^9, 
   3.517673734914329*^9}, {3.517673795133902*^9, 3.517673829984314*^9}, {
   3.5176749639651213`*^9, 3.517674979733261*^9}, 3.5176755414049063`*^9, 
   3.5176818935312033`*^9, {3.517683175487913*^9, 3.5176831855587254`*^9}, {
   3.517683221921268*^9, 3.517683222016292*^9}, {3.517683298036878*^9, 
   3.517683298443165*^9}, {3.517683387784133*^9, 3.517683420904512*^9}, {
   3.517683591271921*^9, 3.517683591870399*^9}, {3.5176838423801737`*^9, 
   3.517683891059189*^9}, {3.517683952375218*^9, 3.517683956463126*^9}, {
   3.517684075556245*^9, 3.517684091052074*^9}, {3.5176841412954483`*^9, 
   3.517684173303031*^9}, {3.517684314293377*^9, 3.517684317389937*^9}, {
   3.5176849632084913`*^9, 3.5176849838732243`*^9}, {3.517685309910681*^9, 
   3.5176853100942793`*^9}, 3.51775267389063*^9, {3.517761641362109*^9, 
   3.5177616483307*^9}, {3.5177617052613907`*^9, 3.517761713028048*^9}, {
   3.517765561618683*^9, 3.5177655884822683`*^9}, {3.517929243707246*^9, 
   3.51792927922054*^9}, {3.517929361793295*^9, 3.5179293907990503`*^9}, {
   3.51793253571351*^9, 3.5179325943053226`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nk4VG0bAHBJklQqCimUIkuosWTrTl7RYs6MzIwUWSqSEjNDY1+SRMky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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1nk4Ft0bB3CptKlUEklZKqGFsr22bpTd88wMz6KUvSzxTGRps5SEkCgk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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1mk8VH0bB3BJKksbydJiSUlRNCQpF0mozJmRmbFmZshSkSVE5ijpli03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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-100, 0},
  PlotLabel->FormBox[
   "\"activation time constant for H at 25, 35, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385570504*^9, 3.518440033488916*^9, 
  3.5186423340662203`*^9, 3.5187028890809107`*^9, 3.549977804793799*^9, 
  3.552325750616477*^9, 3.55232680500564*^9, 3.552396659217971*^9, 
  3.552417195694654*^9, 3.552417248865587*^9, 3.5524190927209177`*^9, 
  3.552574039959495*^9, 3.552574111158084*^9, 3.552583874444386*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["T-type Calcium -- T", "Subsection",
 CellChangeTimes->{{3.4717804882486897`*^9, 3.471780497533472*^9}, {
  3.515527300630693*^9, 3.515527302038533*^9}}],

Cell[CellGroupData[{

Cell["steady-state activation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.515529117629272*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vHaT", "=", 
    RowBox[{"-", "55"}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"half", " ", "activation", " ", "voltage"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vSaT", "=", 
    RowBox[{"-", "5.5"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "slope", " ", "factor"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nT", "=", "2"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"activation", " ", "variable", " ", "exponent"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"actInfT", "[", "v_", "]"}], ":=", 
   RowBox[{"xInf", "[", 
    RowBox[{"v", ",", "vHaT", ",", "vSaT"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"labelStr", "=", 
   RowBox[{"\"\<steady-state mT (black) and mT^\>\"", "<>", 
    RowBox[{"ToString", "[", "nT", "]"}], "<>", "\"\< (red)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"actInfT", "[", "v", "]"}], ",", 
     RowBox[{
      RowBox[{"actInfT", "[", "v", "]"}], "^", "nT"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.51552913920827*^9, 3.5155291526400623`*^9}, {
   3.5155292515728073`*^9, 3.515529311560042*^9}, {3.517336503973844*^9, 
   3.5173365437996073`*^9}, {3.517336945963345*^9, 3.517336946136931*^9}, {
   3.517761460736483*^9, 3.517761465559559*^9}, {3.517774755849648*^9, 
   3.5177747560474586`*^9}, {3.517775774108428*^9, 3.517775774249537*^9}, 
   3.517775809403933*^9, {3.517928278313632*^9, 3.517928278416541*^9}, {
   3.517928344916359*^9, 3.517928345515399*^9}, 3.5179285464044857`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0], LineBox[CompressedData["
1:eJwV13c8Vl8YAHArlSgr+klm2Xtln2uvMl5FJZqyEhEVDSMVpSEjoiKZyd7F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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV13k4lF0UAHBKQmRJtors+76v97XLPjOiQmlRorJTkixRKCEhoZKlZC1K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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"steady-state mT (black) and mT^2 (red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385602804*^9, 3.5184400335169363`*^9, 
  3.5186423341008*^9, 3.518702889118121*^9, 3.5499778048459873`*^9, 
  3.552325750718828*^9, 3.552326805035932*^9, 3.552396659267392*^9, 
  3.552417195729637*^9, 3.552417248914331*^9, 3.552419092767138*^9, 
  3.552574111214786*^9, 3.552583874506854*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["steady-state inactivation", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, {
  3.517675159352304*^9, 3.517675160582872*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"vHiT", "=", 
     RowBox[{"-", "80"}]}], ";"}], "   ", 
   RowBox[{"(*", " ", 
    RowBox[{"half", " ", "inactivation", " ", "voltage"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vSiT", "=", "4"}], ";"}], "      ", 
   RowBox[{"(*", " ", 
    RowBox[{"inactivation", " ", "slope", " ", "factor"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"inactInfT", "[", "v_", "]"}], ":=", 
     RowBox[{"xInf", "[", 
      RowBox[{"v", ",", "vHiT", ",", "vSiT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelStr", "=", 
     RowBox[{
     "\"\<steady-state T inactivation (blue)\\nplotted with activation (mT^\>\
\"", "<>", 
      RowBox[{"ToString", "[", "nT", "]"}], "<>", "\"\<, red)\>\""}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"actInfT", "[", "v", "]"}], "^", "nT"}], ",", 
       RowBox[{"inactInfT", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "labelStr"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.471780586933622*^9, 3.4717807557440557`*^9}, {
  3.4717808325536003`*^9, 3.471780921481627*^9}, {3.471781102068452*^9, 
  3.471781119883608*^9}, {3.487615616891958*^9, 3.4876156269891167`*^9}, {
  3.515521617752019*^9, 3.515521637700389*^9}, {3.515528623896504*^9, 
  3.515528634266787*^9}, {3.5155291255119123`*^9, 3.51552914952783*^9}, {
  3.515529361314686*^9, 3.515529390883712*^9}, {3.5171498539614553`*^9, 
  3.517149854336548*^9}, {3.517336472025469*^9, 3.517336491190016*^9}, {
  3.517675081873564*^9, 3.51767508299199*^9}, {3.517761792989768*^9, 
  3.5177617932289257`*^9}, {3.517761891308401*^9, 3.517761895073028*^9}, {
  3.517761947556224*^9, 3.517761947843421*^9}, {3.517774494447207*^9, 
  3.517774497397801*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVk3c81f8Xx4WMtBDJThRCyJbP2x5Zd9/bMEIZRSgj2SsZfWWvrERKsitJ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     "]]}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwVVnk01d8XlYQQMoWkQSmSKfPwOeZ5eO/hvZdSQqJSkbEyRSVTQqaQzEmF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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-100, 0},
  PlotLabel->FormBox[
   "\"steady-state T inactivation (blue)\\nplotted with activation (mT^2, \
red)\"", TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.5183643856367064`*^9, 3.518440033546801*^9, 
  3.5186423341412*^9, 3.518702889155176*^9, 3.549977804875753*^9, 
  3.552325750757989*^9, 3.552326805084784*^9, 3.552396659319715*^9, 
  3.552417195776536*^9, 3.552417248966999*^9, 3.5524190928057623`*^9, 
  3.552574111293016*^9, 3.5525838745420723`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["activation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "based", " ", "on", " ", "Huguenard", " ", "and", " ", "McCormick", " ", 
    "1992"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t1aT", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2aT", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH1aT", "=", 
     RowBox[{"-", "90"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS1aT", "=", 
     RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH2aT", "=", 
     RowBox[{"-", "60"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS2aT", "=", "13"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tempT", "=", "23"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "presumed", " ", "temperature", " ", "at", " ", "which", " ", "these", 
     " ", "kinetics", " ", "apply"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10aT", "=", "5"}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qRoom", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "tempRoom", ",", "Q10aT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qZF", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "tempZF", ",", "Q10aT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelStr", "=", 
     RowBox[{"\"\<activation time constant for T at \>\"", "<>", 
      RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
      RowBox[{"ToString", "[", "tempT", "]"}], "<>", "\"\<, and \>\"", "<>", 
      RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"actTauT", "[", "v_", "]"}], ":=", 
     RowBox[{"xTau", "[", 
      RowBox[{
      "v", ",", "t1aT", ",", "t2aT", ",", "vH1aT", ",", "vS1aT", ",", "vH2aT",
        ",", "vS2aT"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"qRoom", " ", 
        RowBox[{"actTauT", "[", "v", "]"}]}], ",", 
       RowBox[{"qZF", " ", 
        RowBox[{"actTauT", "[", "v", "]"}]}], ",", 
       RowBox[{"actTauT", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "80"}], ",", "20"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.513457537224334*^9, 3.5134576050580997`*^9}, {
   3.513457635763496*^9, 3.513457657364431*^9}, {3.513457785036035*^9, 
   3.51345781469156*^9}, {3.514061160975711*^9, 3.514061169287127*^9}, {
   3.514062536074541*^9, 3.514062536617835*^9}, {3.5155269688591623`*^9, 
   3.515527081153256*^9}, {3.515527112057857*^9, 3.515527145884241*^9}, 
   3.5163608158334312`*^9, {3.5176699959787083`*^9, 3.51767000792106*^9}, {
   3.517670087298874*^9, 3.517670142917297*^9}, {3.517670212585348*^9, 
   3.51767023499297*^9}, {3.517670295197945*^9, 3.51767031591753*^9}, {
   3.517670524967805*^9, 3.517670625802761*^9}, {3.51767065759674*^9, 
   3.517670657740251*^9}, {3.5176737490670013`*^9, 3.517673751162981*^9}, {
   3.517675299708912*^9, 3.5176753326183434`*^9}, {3.5176753742571793`*^9, 
   3.517675403727848*^9}, 3.5176754340563583`*^9, {3.517675474499773*^9, 
   3.5176754851466846`*^9}, 3.5177526876909637`*^9, 3.5177599315167427`*^9, {
   3.5177655319456043`*^9, 3.517765538153138*^9}, {3.517765597922798*^9, 
   3.517765604947248*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1Xk8VVsUB3Ahw0sJhWTsnigi7sWL1NmRIZnu2RUqSSGRDJFEypBKJMqQ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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1Xk8FvkfAPCyKpScqXgS5YqI53Esqc84c1Q8M60jFVkpJJFISUU/HUJs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     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1Xk8VfkbB3BpIa2WkZ+xtqB7j+JeFEPnyZYscc+RrZrKRJZ0SZJCWdqU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
   "\"activation time constant for T at 25, 23, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385670319*^9, 3.518440033580698*^9, 
  3.518642334204475*^9, 3.5187028892179832`*^9, 3.549977804936082*^9, 
  3.552325750799684*^9, 3.552326805119307*^9, 3.552396659369898*^9, 
  3.552417195816372*^9, 3.552417249027605*^9, 3.552419092850624*^9, 
  3.5525741113519278`*^9, 3.552583874574768*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["inactivation time constant", "Subsubsection",
 CellChangeTimes->{{3.487601246543023*^9, 3.4876012613269463`*^9}, 
   3.51345291116885*^9, {3.513457318358581*^9, 3.513457322348991*^9}, {
   3.513458793285729*^9, 3.513458804092909*^9}, {3.513458868600246*^9, 
   3.513458868679677*^9}, {3.515338272246876*^9, 3.5153382730047617`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vH1", "=", 
   RowBox[{"-", "97"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS1", "=", 
   RowBox[{"-", "12"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vH2", "=", 
   RowBox[{"-", "77"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vS2", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t1", "=", "30"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2", "=", "380"}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"roughly", " ", "based", " ", "Destexhe", " ", "et", " ", 
    RowBox[{"al", ".", " ", "1996"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t1iT", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2iT", "=", "400"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH1iT", "=", 
     RowBox[{"-", "97"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS1iT", "=", 
     RowBox[{"-", "12"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vH2iT", "=", 
     RowBox[{"-", "77"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vS2iT", "=", "6"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10iT", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qRoom", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "tempRoom", ",", "Q10iT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qZF", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "tempZF", ",", "Q10iT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelStr", "=", 
     RowBox[{"\"\<inactivation time constant for T at \>\"", "<>", 
      RowBox[{"ToString", "[", "tempRoom", "]"}], "<>", "\"\<, \>\"", "<>", 
      RowBox[{"ToString", "[", "tempT", "]"}], "<>", "\"\<, and \>\"", "<>", 
      RowBox[{"ToString", "[", "tempZF", "]"}], "<>", "\"\< deg C\>\""}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"inactTauT", "[", "v_", "]"}], ":=", 
    RowBox[{"xTau", "[", 
     RowBox[{
     "v", ",", "t1iT", ",", "t2iT", ",", "vH1iT", ",", "vS1iT", ",", "vH2iT", 
      ",", "vS2iT"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"qRoom", " ", 
        RowBox[{"inactTauT", "[", "v", "]"}]}], ",", 
       RowBox[{"qZF", " ", 
        RowBox[{"inactTauT", "[", "v", "]"}]}], ",", 
       RowBox[{"inactTauT", "[", "v", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"-", "100"}], ",", 
       RowBox[{"-", "20"}]}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "100"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Red", ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "->", "labelStr"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.517659370444151*^9, 3.517659458158696*^9}, {
   3.51765951598639*^9, 3.51765969248174*^9}, {3.517659741124271*^9, 
   3.5176598800979033`*^9}, {3.5176599131487293`*^9, 3.517659980869519*^9}, {
   3.517660107259983*^9, 3.517660124405079*^9}, {3.517660168016409*^9, 
   3.517660188705079*^9}, {3.517664297866303*^9, 3.517664402525186*^9}, {
   3.517666851472773*^9, 3.5176669182186003`*^9}, {3.517668017707142*^9, 
   3.517668030786314*^9}, {3.517668124061599*^9, 3.517668164196578*^9}, {
   3.517668852396811*^9, 3.517669126597953*^9}, {3.517669189249436*^9, 
   3.517669208336926*^9}, {3.517669278062071*^9, 3.517669302605089*^9}, {
   3.5176693482809258`*^9, 3.517669362496118*^9}, {3.517670535286792*^9, 
   3.517670544055212*^9}, {3.5176706344835157`*^9, 3.517670634738987*^9}, {
   3.517671798955681*^9, 3.517671802875463*^9}, {3.5176756792364388`*^9, 
   3.517675751270047*^9}, {3.517675784832855*^9, 3.517675858089703*^9}, 
   3.517752695427099*^9, {3.517933074798398*^9, 3.5179331133502083`*^9}, {
   3.517934264478856*^9, 3.51793426734123*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV1nk4VO/bAHCVQkoia4iQpejMGGPntu9MzAyp7MtM1iTJNxQphRRKtkha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     "]]}, 
   {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV1nk4lF0bAHBJM/adVJIiiahkGfs9DMY+MTO0CSkk2Zc2kiXZsoYsSSr1
SrKUVLpbECJSqWSpJIm0oUV85/uH63c9c65znnt7zkrPAKfdvDw8PMLkz///
N/5Q+T0/74par03an0QZwHfj5D/+c65o4lRsz4g3gDWJk3/7Zl3x4v7V++qT
DSBdvn7uxm9XlNX9G3YmzwA8LKz5An+44oeVNQk+1QbAl+snNjTiik8Fyz4O
fzAAG4Oq1djhir9bku9G2hnC86P6TkcLyHPXs875i43gWLVSfoqmKx7eu/2u
5H1jEBj31O1+5IKFKWffLdA1hUseHdekd7vgL5W9Yi6mAJJ7gyd37XLBpmGV
P5N0gIPBizVqPFxwdln+yuMMALtYj/LNbi4Y3RCqUGUN8LVsqjjNxQUljG6f
GncG0B1dnsJv44I7tpypFfEBeLh//55ZTRcMuPlS9l0agEaEVJmthgvGhH3K
MckAOBVd//a0ugv68s2I5mcB+KTz7tBXdcGKNzEjVnkAQtWnnMNXuqCi47HJ
lLMATlON8FWKPI8OSKyuARg8JLZs+BcXPTa9vLr9BVn/UsSANcPFx7HDOayX
5HzawltuT3Fx9m3YYbPXADxf+HOzv3NxSPWfueIAwEp3XimLcS4uWrUz6cEH
gF2MKcELg1y89YDjcfEnwEfhvj/ezVyUzE5N6xWnQ6DvqyXPHnLx3wiLkihJ
h19NvTR4wMWF9pcYutJ04I9+Fi6HXJT/2iqSspgOa791fH90k4vebtnF8gp0
8HuOY2uvcDGqS0yxS40Ok0UXXn/O4uKpLfJtIWZ0ENyyfa1uJhfNf9LcZszp
oCwtGXk0nYsvxALEIy3osDXpiIxMKheFv7c3BTLp8DCczTJJ4OJ6SquWqQMd
8hx5m9Mjubj8j7qgwxY6VAvWS/eFc3FgwsG7dCsdOpr8d60O42LHmOqdH9vo
wGv0iqchiIsRVVetU93o4K9aZfh+Lxe/BfaWFeyig9kCt2s6O7hY2CWxTcmf
DttvS/Ec3cZFulzpOsv9dIiIaHVo28LFm1NN3bsD6FAxoT3uxuXintrU1IIg
Oix+LbQm0ZGLx7yLk4bC6DBefbPwNZ3EX+9sXucROlD2B3xWBi4aaF06eSeK
DivXrjYIMOHi3qQCnUvRdOCeSe9daMjFM8Pq8eExdMBkb0kNbS7aaBT/GI2j
Q46XTGK0Chcf/MmSUU+mQ8lj86fdylxcYno6Z4j4snawvLISFw9zyjAzhazn
e1L1aAUX2d88xSZSyXnKEl9JLOGi/6klnAPpdJgRvqHktZjku6jlu1QGiU/Y
B//rMlzc79Ot9h+xnIUZ7zZJLpaq13s8yaQD48NftTIhUi9GrGtfsungaK8W
Ni3ARcM2p1H/HJKvOte7TH4umiY6XPpEHBhf5zzBx8WZMdl7L07R4dDE+yLT
hVzUc3slxcylQwJHcjRjARdLyo+O1hEXrg44rDvHQUp+hNjxPDpcTC1qTpzl
4Maolh1jxNVT7eJ9fzh49v7sapt8OjxqUj0fPcPBkmkV+XniHg2Xye4pDopq
rbFkn6bDQE68vvJPDgbsV3p3nvjn7ncdj75ysHSvro9JAR3mO8Tllk1ycGal
l0M8saCuqaf/BAc9em4VPyKWKfavuPuZg0WP7Fz4C+mgSCmclhjj4IbXa8IZ
xOr728BrlIPHQ3f+Pkys++JX0vURDioWUQevEdtd4KzY9p6De9sXtIkX0cFF
NM73ylsOyvDHtRsQe4ZX18wPctDHtneNB7H/wNC/zQMcNBxZ3B9LHGkpxix7
w8G+t7s+lRLHVhpnTr/moOOiPptG4jTZfW+YrzhY/rp4/jlxftRplYJeDnrV
Pl00Rlw28ihw4jkH71YXbPtDfNVhpsH0GQeXtSrOU4rp0HB99aLMpxz0e5D0
RYy4SYHtONzFwSxbPlUZ4q6EY/m6Tzg48uXmJVnivi9V7xM7yHOl10HSxCPc
QY2+dg6udciJEiX+1igSqdHGQYGW5Z18xLMqRvejH3FwbvCi2wzZn3pyr/DT
Zg5e++SrOUIsOZPHVW7ioLV+oWE38fKdLSXhDzj4U+NAXD2xasvU2KN7HIzX
NaYWEm9ar6yzDDko2Kty/xCxSa5TtH8jyW9leI0LMXP+aOvd2xxcfTjg1Xpi
Z++rUpK3ONi2mqvFRxylpGcac5PsN1so9JLkp3ywce/XGxy8+JKdVU4869J5
r7OWg5cCTpabEqtIcyeMazhY6+i0iUK8uatf7so1DuYmUrxbSX1cYE4EJFeS
+HJfPLAg7uILK/hTwcFns6Zjc6Te/uJss+9/HExbrVdbS8zSF1ZglpN89h3R
kCX+vVb9MV8pB91ulaZXkfpWHqmeCSnh4H9Pz1Y6EDuUGii9L+bgIY/G3Z9I
f5QutTl4r4CDV38YnpYmthPyVY3K4WBGkPpvOum38JavzhNZHBRx/3z7IenP
s7GR0dszObgy7pkYg3j67/EXBic5mDno4EbLosOZ8QtxM4kcHM9JPzxD5kFb
uWbVnuMc1E6m5bkR//S63vc8noPzVfn690+S+PY3adUe4+Cji7/4o9Po8L1j
eCjwMAe/CjY2dJL5I5+0T3joIIn/orrhJcRWlj/1HA9wsGMmJtkjifR348KT
GuHkvC9cbEcS6WBxdZXxWAAH+3PSwpviybzwu+yzZT+Jrw76/iTz7vQarexH
+0i/CRzsXkH85Qz98wVfDk5fTv3jd4zM/3T3/F27OBjR+DP3FZmnn4OKp95w
ORh+a42mQATJb0o/S43DwYI36DpK5rHXRfmKCGcO0ionLB+Ekvnw5rSnJIv0
u2yb775gkj+r3CdW1hys3NJXkUzm//Xl6ZeqDTkYs+yq4z9POoTQnvDxGHAw
dSevcZ4HHTY4i7rb0zh4AbsHNN3pcCkxRXZUm4PNzVeMHHeQ9/2RGLtck4PM
mBbb7S50ONYasyNRkYPrG5cvuWhDB9NhrH+uwMGtCRXTs+T7Njs3L6W0nIOT
gT1HHKzoEKYd1XZnCQd7QzoShsn30efMQb0fkuT97lSFvTEi9REWIuG2iIP0
oAs+fzXosGTl7qZNY2x0zLWu/CFM8n3y34LiUTYO+IW2vxekw9O5HBP+j2yM
+WSwtIufDklvmm+8ec9GDdNRuyI+OvzJVb0c38/GJ6lNAoKzAH2i42m9XWxM
PyRO1RgDKJoNdj10g42ZGhvkCh6Q+5KfUM6HOjZW0m6+kbgHwH19rtuxlo2p
dEZ/XCOAaP0zG+VrbFyW3Jm98yZAVIiuccdlNnJY1yY/VgLsHPu9ckUxG22S
2T8Y+eR+8vLo5/txbAyMbZTR9QP48iNDSSeWja7uyxdakPtVg9i5bRdj2Bgl
QvVn7QZgWzW1J0exUWVgvGH7ToCE6wIV7Eg2lq6V2mlL7mdj2Zn7RvzY6JKQ
2RtjAFC9uWxCwJmNPw6mD2+nAJi1t0yyVrLxUmO0obWqKZy1SHc5u4KNwdVj
dxYrmgIPut79tpyNtNns7wOLTaGx9lNa5lI2dnQuPeFCNQX9YiHNZ1JsjP5c
IPj9gwlsCHLc50Jh4yNG47HusyagsLh3dMdnZzSg1dXsljaB354jb/fWOWOc
idEfjxEjSOLdqnaH5Yzf5zyymQcNoMryvHvBeyeUnl5erF6mB5PNy8IiI53w
xo76Dblt2sDv+HEwVdoJtXl/iS7bpAU3DiXR1pdvxo1Cz7uDlNcDVB37yG++
GdmWV87P31CDnSec4vY/Z2H8xKQ65YQK1IaZyGIPCzc+tmZ8PKAC/J5q5RJP
WchRDox+ulcFqg14H9d2svD5SvltLXYqQBm/JvW3hYUr2+XS1SRUoMJB4tzx
BhaeT0sTfFGwGv5Idd0rOcPCgi9C12/UK8OpYvv5p74sZHy5vEZPXAkEBzOD
6T5k/xz/jn18ShC14uWHq3tYuJer0nP51yrwLvF8nLKLheulZH+avl0FtNKI
fMsdLLxTMkfvrF4Fr8+f3dTAIuvXzFZEuqwChStT3mf1WLjZv7zq64WVcPFW
UVfAIhZWmsceaNyhCJVbT4fcXsjCwYez/1Y6K0Lt71OyArwsfLjN3T+NqQix
AYo3Gf8c0ZAZ/ydmkyLUey/qvjTpiDGcN3Y9AoqwyvUJT+gzRwyxGArXCVwB
07Rd7vzFjugSMT2oq6sARX+SVmzc6IjGrxbMn/uxDMaGdFX5NB2xl3V9tO79
MtBtebehV80RuZueGj3vWQadWQZmR5QdMWj7uoVGtctgbt2YV+tiRxxXq1e8
FLYM3HZaX/aYc8AMk3c7//xZCgoPqTqZ7Q54ulTyk4nYUihJjbP5sdsBTzrf
2xSzXQ46OlbavPB0wH+N5+bGHeXgj8hd65s7HdA0vqlml7kcOKf9ZkZvccD/
ZKwbg9TkgHJyv5WQvQNeb2VEi/1eDP7prgwlbQecN10oZpu3GAyy1pk48zpg
gErT/dQBWfDuaTXWnbfH09X7dZk9spAt5W28ZNYez89sKxN+JAsTWWeNBqfs
sft48eaaa7JQki1r6PfJHp22nFGOiJcF6ikeWmyXPT5NVLV7qikLz/Kebawp
tscU8bb1ZYkyoHJqKN2pwB6zVR9urzsiAxFZ45Pfcu3RdvYqrTtYBpam8VVu
yLDHmU1XXqnukAH3WG21ylh7LJ71bOFqycC4f/aqSz72ePa5ff75AWngM2dL
ndGyxxKXD6ZPTaSBC+7BJuvtkbWVh6uqIw0Xjfd196vbY6jpCkqiujTY0OJO
yq+2R51bvFJectKQrlErdHoxOd/ysunU71IgLyfNlzNrhzNnNl89Wy4F2hM9
P5Oa7bBj+Lhe+jIpeJiZKev1wA6z17ozCqSkgE3bTDNGO9z4+mrHFSEpCIvt
PDR50w57dqcbfforCdeXtPKyr9gh727VN/VvJEHfslF8ebYdtp56Xld3RhJM
zpSvu+phh5EtzTp/1SShk+HtkOhmh3Bp7vMnJUlwG1sd6LHNDqM7n28flJeE
aJ1zNVIcO6y+reoyICoJ2F5kEMm0w8Lb5cLrfkiA+a9MJn29HW7V+HJgwR0J
YG4+4tUza4vrHQUV/DkS8K/m8gef37Z4v2/Tj7MOElAt+3LP3JQtWuy+2t9v
JQHyb7R8107aojQtqnevgQR83TPqH/3WFnUG28++XCEBeYedI9SbbfGZf9Pt
f5/FYfTi2qTYk7Zovr4uEk6IQ5Ggi9CSFFtcPRqtZxsrDk7+cSmVibbIL37c
aPsRcbitNZj2KsYWbaQaeTKCxCH9TnbW+lBbrB4Sa2FsFQdaz3xhn6stfpio
XNS1ThwS555f3bTKFuce3jHPqxADhVs/17xSsMWvTsLfXUvFoDZCqiRqmS3e
+babpZwnBoNfWemt0uR9wvb8eB0rBrrv2wN3Um2xvrXxavM2MRhuubcxedwG
X9YVUk+KiAFkXKl5d90Gtb3KVYsiReGF/WP1xBobTOiRNigJEIV9gp/PaVTZ
oEKI352KPaKQG6uaHXnJBv+9sP75li0KX8LOhYoWkvWrGpbf3igKhVvzdQxi
bNBCuXLzmgkR+K0UfyPD1gYLVxSFn94rAp2J3O+BTBvcWTKSQd8lAqUTazRY
Fjb4XXrjxOQ2EbC70VYqamqDx8wSmJ72IlBsI56WrGWDm/6cfVa4QQTMggq8
4pfYYE/NoM+uX8KQ0nhN4sBHa/S+1/6aP1UY3JVi7VyHrXG7+/y65ARh0Elk
H9d7a43nX7+alDoqDAObZ2anXltjuQL1Ki1EGDZ8MBoN7rRGLW2Kb+cWYXgu
9KhxX501Sqj8TFqtKgwKWwb83GOtcax/ScaWViFYfEiBMhttjY8qc/tWPRAC
8SK3ktzD1qh462L/99tCsPDtwLPOMGvsZiWOX6gSglGfQWNjH2vcQOUPccsT
gurIIbGl9mT9xRsqi3yFwDLvXU2PrDUuT/xayCsmBKYNqxwCpKwxy+lJW46A
ENDeeI4KiltjIIWnX5NPCNQV38ubCVgj9VtOTvBvQRAvfx9f9ZeJxXPF/5kO
C8LrG8MuqUNM7E/RWvG5QRACekf+Wl5mYkZVwe8d+wSh/OwrV/mLTKy89Tzn
u7cgDPk9rvt2jolDKpPXkncJAounOqCwiInh0z9d2rcKwoa1R95/S2fi6z0X
BqOtBeHrQan2wggmBh4bFmlYIwhBCnD6O4OJzXF/DTgfBeDyqNZMC52JsxTv
mKD3AvCuejW7yISJF2l89zIGBcDJSkiUSWPiJ09e+YFeAdAKfBFTpM7EV/9W
95x/JADf7+3zZUoyMS3m87uJywIQsjufVjxohYcyEjQsgwUg5cSRlNg3VihO
j/L/vF8Ayq54DPm8ssLtXjLC2X4C8GJqbeKmHiukt3x0mfQSAIOEht5HzVa4
74lWZ4eLAPBc7Av/ccUKT7xf4b7GRADSRpfXMQ9b4RD7m7CeiABcFOYV0DxA
npd++UYXFADcMLJdKtwK5TxDux2p5HyRlXwDAVZYdc41NHSBAHAETNkhu6zw
zo++maEpfpBXc/9RZGOFTPusIMYgP1zyK934Q84KN2l4FKys5YcRu6nhbBkr
LHWLuGR/jR+UNZl5upJW2JV+qOtwJT+UfJ2YOyBkhV8uzW4bLueHU2H6j3nm
LFH1ia/wyyJ+OBbdtUf0vSUuvOH+xyGRH7ZmzRWsvWKJ65avmPLayQ95oZsd
2y9Z4he6zsTEdn54zinj9b9giUV/BU4f2MoPLDkb36ozlnilwZSSz+EHy6Ic
Xb1MS2y2utU7Y8sPWhfXdTMiLDH25JNBLX1+ELq1leJOt0Sfv9Ork2X4IZHh
ftjQxBKXxqZQk6T4ga9z93dZQ0vslX85kyTBD7NDgQMd2pbYOmgymynCD18o
x68bqlqiyJmDW28t4ocup5o9i8UsMYXSUeY3TYVTY0ItnW8s8C29Kt/oFRUk
QyWML7+ywDUhjQEHeqmQ9k+2Jv6FBRry1cjUP6fCcfFVZ4y6LPBW889Wg6dU
iNSlRVx+YIHbVFpKOO1U2HbMa03CZQt0PzQZOniHCopL7xw3jrTAI5P3j+iV
UeGe+8Ydz0MtkJ0UV3yilAqeF89r+QdZYH2izJn+EiqUaaf1F+61wKAED73k
IiqoOu7cNLvdAnnk6Mmzp6iwIW7BYAPdAkVvbJ7VSaKSC7qFLk3IAvmTBjjT
QVR4q90g1EW1wM8vEvKOBlLh2CHNt958Fqh25edh4QAqPORfnJL7j4Gb/T4p
rd1HBabS6NvpSQaK9K6oD9tDBZZrUmrdMwZm/tsSsHUbFTzudw5rFTPwX0iy
qqUl2e/a1GG+AgZOfcm7J2tB3q9EXuZFLgPVWI9zR82pMHRkr8WBDAYaVsdO
n6RTwV2fcuFuHAMl9p3aMmFEBbcqY287PwYOtKYXvd1Ehe3FFZ920xioOjCX
d3EVFYxSe2L0dBh4k94aXLSSCvKH/ywR0GKgseDiXdmKVOjbwrSpUGeg786b
x+IVqLBVZvjydwUGXj9/rzh0KRW2pCzbF72IgZWzg07xklTgHkz6kvfUHM+u
zdLwXUgF2QelRw4+Mce1f8Mc4nip0Ct0S3j7Y3MUuLd7a8kCKrgWfVZb0WyO
p70r1/fNU2Ab2nmfv2mOLR6jddtmKeBOERu6VmKO6X/VvY5PUcA3M6u7bb85
hsy+E48dpYBa33/uFX7muHKi5dnNjxQYU3o4mepjjlSlBO9vIxTYV/dTZLOn
OR7bZDbt+YEC+19ybHo55iii9fSs4zsKBCvIPXhvZI6zgY8PO7yhwOHLhbWz
guT8lxc+etNFAY8qpXOnqea4TKHpkzyx5fXLGTQ+c+RJy3m74wkFJO7X7w/9
Z4a2NZWO7zoocOHVM9XxSTPUFRQUnmqjQBe/SFHfMzP8cWfcgN5EgdXeR+Ib
is3wSE0ra38DBQT9+UJdC8wwWTDpUMtNCnwNTvaczjXDWGq6+0rihqh8U60M
M3S20uL23qAA61Td70uxZnjw/p5XtnUUONg04Z/vY4a955RPcqso0Knkxo3U
MkPWPRuPiQsU+N6dS2WtN8O8AqHZ3cSyR7vr16wzw5rrC5QHz1PA7Q1jWe9q
M5yZMl/SU0aByWz1IZ0lZqjpbXziXikFxCm/fX/M03H0QPeC+mIKbB7NOrK/
g46LBApPUHMpEH6qQ9OyjY5nAlc0pJ+iwGkGdWh5Cx2PXynes5T4XclBsw6k
Y83L1I3rc0i8t3hQ19XSsYNOi3HLokBmm2bGp9N0DEuuze85SYFnFa1lXj50
XDywdov0CQoslwuu++VFxweCe3efS6TAntilzSkedOwLCfqmRTyzxe9j7VY6
apadSnA+ToGlVBG1RfZ0XKhbmnM6ntSPB+vq+Y10rNdf+Nj0GAUmZHpvjvwB
XDR29f27QxTQjYluOzgDeCqpsv8ocdT4mj7Rn4AHnp2xXEEs/iByVncC8JzH
nl07DlJAO3Cp6fFBwN7+qYaBSBL/th0P1zwEzLcNj5gKowAlerjTJxWwech4
PCCQAhsYUS+EkwCLN+zzkSfeIiA3UJUAyNwWSm8NoEBFlu3Er2hAbckIfmVi
p/JqoRPBgEEhioP9/hQ4032UeckFsImP4eLpRwGa8vL7n1YCfq5f3P7fHgp4
frremqoAeEQxRGkXcXIlq3vjMkAfseLHS4kHaHFDB6QBr3nNiiXvpkCc/ec5
ASqgzLnVmwO8KOQ+FhzBfmmKQRONgZaeFOjJ/G/v832m6HVY7vk6NwqU+TPm
0/eY4laj5P5vOygQyuzPsnM3xR0Z2ko3iGXnRO88cDbFvDqN3WbErr7BYtUG
pngb+m5v2072N9WvTeM3RRveBfH5W0l/jjf/syozwRoe02emLhS41bIzc2Gx
CbI940WEiVNKf6nczTUh99GTh19yKaDhqsbSTTbBjyzJv0HEgQ9SS5WDTdB8
08OQixwKTOWzrRaACS75wFSWZ1OAx+pdekOfMd75lyauvpnUQ6Hr8JdnxkjR
qG/5zSL5+9app9RpjK/NPa4/IvYpuDWQjMZo+1tf35u4ezJ73Y7zxrgzkNF5
wZHEJ8/q0fx+Y0z6ksOzwYEC5mMV8wxeYwyQLx7zsSX9Y6rkfOCvEeZ+FlUw
IY7Mzr9w5acRXsuoi5EirjBJsJf9aISKPe0vG20oIJ21s+BjuxGyIo1xMfGw
oaReUo4RcjwXWj5lUiAhNWL/E1UjrOUJbvGxpIDCJmeriFVG+FI+VcqS+PpL
TcUV8kbYfkktTon4g9JI934xI+Qfcn46YEEBRgNbR3TaENfy6im4EPN+3Dhr
98AQZ+7GOjswKHAExk+07TDEdw00Xa4ZOc9Ii2ewiyGOXLNt1yOuSD5nuHSz
IQb0ux9dQvzmxdYJX4YhegcL2fTTKWDg38oSUDfElHO3XfYQ/8q/sJj5ywDF
LV6ZRgGpjx/u55syDdDmpr7XQxMKdNit2JeaYoDRzWNwmVjlQr8WJ8EAzbyy
aenEr1y34vABA9S29IzcTmzS6Ny30MMA51M/6E4bU4D/hKWE2XoD7LzQkatJ
XKiw7khjuz46mw1sqDYk+Y8YM09o0kffpve0AmKH7nJBh7v6aNlW5BpHvCBu
dV5/tT6W1HcMcIn3fFKomc3XRzmjiIX/DEh/1kp8MvDRR8V0yXx74ofWM+wb
fPq4zsLXeZ5Gfr886/XMPxoqhabt/0Qs8E3TnTZDw95svdIeYoe8PX43P9FQ
TrHcqZz41cjzmFudNIyiCT53Iv4SW1t5N4+G9S9DmBV6FJBrDOJ/tI6Gi1I+
agfqkvmeIZLGr0JDiU3/aewg3rH7kpT1Cho+YTQa2hCXCr9VaJOgYYVPSK4y
scY2ls7jaT0UxDib1zoUMPul6dmFemg4+C3Jmnif1vitl2w9/CNzpldXm/QT
d6I5xUEP1asKfNYQVxz80g1MPaw80CAgRzxx/+vHckM9LGYuO/x7E/k+Ok9J
HVilh6F+p1bcIQ4MnfNb8lUXF8iKO1sRh14Xl9+arIvZhwJm92hRIPu1xBrR
eF3MNXQN3kJcOyepdT9KFyPv+EzbEk9ZyjDVgnWx+nuT6kbi8N4loX9cdfH7
txfasxtJv/xa9fi0ii4uiqjpzyY+bKBzuO+eDuZou4t3baAAd/qa6LMGHXQN
H++8T7yhWvPs4xodPHPta2Ed8fBa1eY753VQnrLEu4DYfsky8ZITOtjtNHXN
m1jhF0+Z12YddAiJkVxIfK/ucfvEkDZOrVFPZKwn9RRk7TbyShsz5Byl9YnD
NZq/DjzVxm1tXVc0iNXO35XpeqiNLWpX+RcTZ2ZX76wu10bR4TXbxzQp4BWS
9yM8UBtPdT3Yl0Vssl4mIcBXG48kF7YkEst9zpDz8dTG37/eakYRP/ZMNt7C
1sZKyoFVvsQ6TlHHDWnaaOZiWWhKLC76d4n2Rm28nP/dVYd4rDWiYp2aNjIi
8leqExfTg7qXy2ujtNaZF7LEkf8mdsnKaOOIw7v7wsRON/dOi4pqI0/CaAMv
8bqwj4lUqjYeXFHW+EuDfJ82ei3j4dHG3SHUzi/E/wOoRCDS
     "]]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[CompressedData["
1:eJwV1nk8VO8XB3BJKJKlRJYSinZ1Z4z9YDD2bWZQFJLdjGSrr1IpKZK0WitZ
SipJm0onlZ2QFApFEokSWsTv+f3D6/263Oe5z/mcc6+KN99ph6CAgIA4+fH/
3+VjK37PzLhiuBzXcdewH/wwSPwTMu2KDGvDIosxP1iZMPK3c8oVX3H+Fin8
9oMUxfvT93674haj2WkVQv7gZWYpFDrmig1CkYNiiv4gdC5oQU+/K074HR04
ZuUPVrrF6tjgihvW8SrWFvjD6/06TvszXNHzXu3V7K0BcLBENS1pnSvGLCiX
ftYdCHO/etObq13wGvM/j/z1wXDVq+HWwh0ueH+LkWy0awhIB4aNbN/ugosv
/5qr6RECe8IWr73t5YKejmcb27xCwCbO64rjVhcU9Xz6UCMoBEZzx7OTXVzw
/SHX8ry9IUAfUEoStXLBW3GiarNyQuA5j+c7tc4FtwgvXqE6EAJro2Ryrde6
YMKec798v4bA2dj7H9JXu6B4w27VgtEQ8E8R9NDRcMHU/H9hir9DQKzkrHOk
igvmZf5I6pjLA6fxchiVccF9cqasS6t40P3fAoW+X1xcLzYcaxDAA/+383Ud
Jrk4ZXXB93kwD0YpcbdH41zc/zj2lkUoDwS+iZ47/YOL8efbfU2jeKDiKShj
9pWLme83jEsc5sF25vi8/G4urpXbXD12gQefxTv/+FVyseRvX8D7Fh6EBrTL
tz7nosmt6cODr3nw68UbBjzjYlXipayxtzwQjW2NlEMutuTblfzu4oHm94Yf
1Q+4aMWoWvh6kAdBr3FQ8zoXFSx021/M4sNIVn7H0CkuTjQcXRO9hg/z3Nw1
6alc3FVSRVHr+aC2UDp6fwoXV7QbiQ5p8WHzsb2LFh3n4tVLkzMsbT48j2Q7
GMZzUWAn49ELYz6ctxesTInmIv8+7W45hw8l8+4v7IzkonIQN0rdlQ8NL0K2
q0dwMTB2NcZv5oOgfrtA2U4ubriv+JaxjQ8hGsV6vYFcfGrvfm2zPx9MZm29
RfPgYihPe9PJ3XxwfyQjsH8LF13OFkVl/8eHqKgau1o3LopIVQjk7+VD0TD1
dSuXnG/M8qbLB/iwuENsZYI9F+Xq9UbcjvLha8mDzA7j/+9XK7noHB+Eefwh
NeBi992MVe5pfFDRVNflG3JxjTC/Zk4GH7gXUt7M1uNitv7Xf+bZfMBEP+m1
FBdD5r18uT+XD2d8FiXEruDii01HEhpv8uFivWlLsxoXG955b5a9xYdCKkxR
TZWLwUKZK11LyP8LvSyuXspFxyNCeTWlZD+5Ce1S8lwMO6xSsf0BHybF76n6
LObipRSHOf+VkfOJ+BRydxEXcw9UqSc95IOcmYngFmli7fyRjMd8YH76uypX
jIs/TVhGO5/ywd52VcTEXC4eta8Vcqkg9brj+oQlSvKkNnWU/owPoYfvOA8L
cfHGj7rnH5/z4b/h3iyj2eT8Z5R23XzBh3iO9MDJWVy0npfQElHJh0x1fgx9
moM939XPjlTxoeB4VmXCFAcZj5aN5VST+o7XSXb+4eCRsKc/7Gv4UP1CIy92
koMRt7Lqztby4dVal5HmcQ5KKJVmbajjQ9eZwzpqPzm412aF0HPinzs+NlSP
cnDR7tHYN/V8mGmQlFMY4eD2EEaySwPJI93IO2SYg/IrHi1vJl6UHVL0ZIiD
P/f+0WE28mGZcOaE1CAH/y2NaComXs2rBZ8BDj5KKf4o+5IP9LZfx+72c/Ck
NhUSSWyTz1m6pZeDtkHwXqWJDy4ShwKuf+Bg+NH+hyHE3pElt2e6OSgjIznn
NnFIV88/xy4OlgQ63/lOHG2+gJX7joNuElY1ms18iLthkDrRwcGVl1IMthAn
ywa/Y7WT8/pZKRFPnLYvfUXGGw4WyKToFBLn9leHDr/m4EXL1LIq4pt2k2VG
rRy8ti4quYu47K76nNQWDq4vHrr1jfiFMtu+r4mDb5dcVPlF3BR/MI3+koOR
aqyOP8Sd34p7Exo42Die/naCuJ/bvbazjoNnKWf5r8Tfy+dHr63lIGv++rQO
4qkV+hWx1RzcZDDKriAWOREo3lLJQV9Fd8vLxNKT57lqLzhYVaC3ay+x0raq
i5HPOLgscctLB2KNqvHB6qcc1F+dtFmJeNN6NZoCclCg+JJULzkfw3NOsSHl
HMyWCP9+iZg1s7/mySMOVsh0T7gRO/vdlJF+yMGmkAplMeJ9qtpGBx6Q8xhf
7vmQ1OdKd3ng6D2ynrvU5R3EUy6NTxtLOZjYnaZ6hdR3xULusMFtDirf0XcH
Ysem93LXb3Fwx5d9SS0kH/msYX7iDQ5aGyyq7SN5ahKKyPhTxMEbOoktPsR/
caoy4BoHF3j0VXeR/DnoiCuzrnDwZURBBJK8/tZcXS+Uw8F22nSSLsm3Wn/J
5K6LHGyRFao4SvJvl6Or2pvNwaxx6ZYW0h85S6z2PM3g4OqnS/c4kf6xEQvQ
2HeGPN+Co4UipP8iq0adh09xcHSZU7Q66c9LcdGx7qkcrE3XXGCAfJj4e6RN
9wSp7yqbE27lfLjwNf/QZAIHrz5bl2VB+r/2yrpi3yMclNJZFrWJzIefPnc7
Xx/m4JzNC+fK3yfn+/7FxtKDHAwVqLFpvsOHHw19PaExHNSOzl0yUcwHxWPB
4j17OKhp2fTfTTKfLMx/atvv5mCby/dD3jdIf5fPPrE2koMPXbccuXOND2Y3
lxsM8jmoWHxv8YJ8Mi+CCv3deBxM/uwad4bMu/SVG09XB3NQuGvkyKLLfPh2
wXgoP4CD31+1sAUvkvmf4pm2fTsHdbup+mQyT4d2Zo+/43LwjMPruzsTSX2T
3jus4nCw9fgmUX8yj30KFIuinMn6a4dKuEfIfHiX7i3twMFvXlXiSnGkfhbn
XlpYcpDjvjXbdg8f7iqlXC3R4yCtPu+Wvh8fdjFeCgnocjDuakrFPR8+bHCW
8LRlcDA9N1VqtTcfriYkyQ5QHNzmMt/njzt53rGEOKV1HDQ68um2nhMfDtYc
8EhYxsGGPPEPFnp8MOrD+6+VObiwxZlmziD5m56RUVXi4Isk4VJ9Gh8iqH21
j+U52DHatUaavB/9L+zRHpMm/accN7Z1OclHxC6prXPI/JFp1owV4YO8yo4X
mwbZ+ODV2VttdTyYOPFvVvYAG8/nLjJUquZBy/QZQ9HPbPT4cXXQ/TkPjr2r
vPeul42PnmXnVj3iwZ9zGoWH37Nx77kVl6yu86BT4mvymyY2xl8OFxA5zoOs
qTDX/+6xkZtUMdvDggd7gsTOfLrDxlfJ1j7VJjzgdlxuti9l466iksk1hjyQ
uN9qpXaLjV3ysQ8/UDzYt4tu0FDIxomy5De/VXiwbfC3ytJsNo61Se//9CcE
VN7uH6o4xMbwN3W0OwUh8G3spCotjo3lMwWiO8j3VdmCy1sKDrDxXv73gxJZ
IcC2eFGXuI+Nbv2tEXapIRB/d24RO5qNrtdfJB+MCYHB06nB/UFsLNHwiXxs
HwIljrnDc53ZKC7+QPDE92AwqasacVBh42OtKjUT1WC4ZJbicmkpG2Oft33r
VAgGAXR98l2JjQJiW5bxFwZDeemX5NQl5HlGRRoPzAkGnWyxda0ybJTO0+xz
/RwEG3baB7sIszFVZOuFlqtBoLz4zYDHkDM+/OSboLAqCH57938IvOOMG0Qc
h9zlA+GY4OZVjx2cccRq4S73L35QbJ7nmdHrhIOlxYXZbjtgpFIhIjraCb1M
T4Y8qfQGUfvP3ccXOmHBGYvcFL4n3PvvGGP9FUdkmM+aV7vUHaD44GdRU0es
eXOHK6fiCtuOOh3ivXbANp3MTYNubCiNMJTFVw6Y8qoyzMSGDaLeq65ItTig
Sqtp+2VDNpToCtaXNjpg3+hu+YOqbBD+ekvmb5UDmpTYOhYNO0ORndTlI2UO
OC+jpvFunDP8kWl6evGCA2612O+dcdcJzmbbzrQEOGAwY3rAUNsR5nWnhhn7
O+CjC56L0tY4wr6lbz/d9HVAbvxo8x8VR/C76F2ftN0BJ5LoP1rFHYGRE5Vm
7uGA/QvOJvV+dICOvEubyhwc0Ln+pqB/igMoXx/3u6TtgOJHvl2f/GAPBQ+z
mvhzHFC19r6h9wlbuLE5fdej2Q7ImtXdrB1jC6W/z8rOFXTAPLrbfqUAW4jj
L3vA/GePArvlJORNbeG+35zmqyP2uM1PaHbTpA0sd30pEN5qj8O8ilGajw1M
MLZ7imbb409qd3Eeyxqy/hxbqqVljxouXrvVDS1hsIeuIbTOHg+tWpddsd4S
6FUfN7xZZY/7tx7tCVKxhMZTuiZ71exx7j2xix+FLGF6zaBPzWLiZEEdz3oW
bN1mWeg1bYcKs/UtzniwQPm5CC21zg7nefzilSRYwMXjh6zGdtjhdjt+m6yA
OTQ0qFi1edvhqOf8+2U/zeDP/CeWD7bZ4YCTYoT/FzNwTv7NinWzwxH72b4f
WsxA+ATPQszWDiW/nfBm5ZtBSIorU5WyQ9ZNzZo+OzPQPbXG0FnQDlMvhD9b
WcAEv1c1BvQZWxR3e9n1O5MJp2X8DOSnbDHC58NUayoThk9d0u8et8Vx/0sr
8vcx4eJpWb2gL7Y4J9gu6jaXCSJnBRhxTbYYVqFpHS7KhNbzrVq3s22xJ+39
Oq8wU1hxtifFKcMWt5b2ZBzwN4WoU19Hvp+zxZIdlTeubTWFJclCNzactEU5
25k8RWtT8IyjVt2Is8UfewJ/h6qZwteQ08uv+tuioxVT791bExAyZctc2GiL
RRnmOvEsE+CCZ5jhelt8zjKUrjcygQKD4Ob3q23RlTfr3BJtE7BiHDqhqG6L
zAY83KxuAilrS8XSF9ui+4tx9fzZJqAot1DozJQNmuSqfOtFY6CGX/08VmmD
kt1CIfuMjeF5aqqszzMb/E85qtdO1xjYDEeGAZLrvFzFFZuMISKu8b+RBzZY
P7MHB9SM4a58jSD7ug268frWl4sag455uaTSaRvcvcenKrcZwPDClTU3vWxQ
13eOh64/QCPTzy5hqw0esY8IfusFsHVQPdRriw2y9548EbMFIJZ2+bYMxwZj
rr/+22YHgHVZutEsG/xmd6DjFQ3A9Fcqy3i9DebODV79RQiA5bjX59WUNdqv
y3R+bGcE/24XfvL/bY2j4oNy0SZGUCL71nd63BoDvb2uGtGNQPHdxgDNEWs8
ntP856eSEYz6DoTEfrBGnWXD8yaHDeF8jHPU6kpr1K0/6WqXYggDBZrH4k5Y
47nOpa6T7w0ga56LmHySNTI+aeyhXhmAU8ihpBsJ1jhryvl7TLUBPNrYndx+
wBpZZg9K1t82gJTHp0+tD7dGp7rNtgpHDYDxaiaz09Uad8YEuM/SNoCE6dc3
Ny23xmX1qsfK0/VB+eHPle3K1ui2ZWnk3pP6UBolc3GfgjWmp/4VNU/Qh+5R
h5SahdZY1nTi31iEPtB760K3iZD9mu9RqHDUh76qp1qJX62weeVHiaVi+gAn
r9/+eNcKcQMvNfOQHrTZ1q9OuG2FXOXJnH0xehA8b+jy2mIrPFG2UC8gXA/O
xWmcjr5qhSOmaj0uPnrwLeJyuESmFcrdb5JKZ+pB5uY0mu4BK9zQH95QKKwH
v1UP3ztpTfxl48/nKbrQmMD9EcqyQueHJm7Lj+lCzvDKtQ5mVihtvMsqPk4X
bO7V5kgYWeGmFefve0XqQraVZHLiRivUfohyvu66YLIzw+ewvBXezBu/cEFT
F5LKb0nt/myJpWN9J4qqdcBTNc7Gtc8SI/dIDr+s0AFaAvuI9gdL/C2voPD7
kQ50OU5OjXdY4lhX8Sv3Wzqw4ZP+QFijJS6LVlEKSNeB12LV5cF3LFGA98Ip
JUQHlN26gjzjLPFNxxvrn4t1YPF/ysJTsZZoufcgukjrgGTW1ovnYixxcr6c
+VNxHZj9oau1McISmw4+C8yfpQMD/t0GBv6WqCFTFHh/iAEl0T0Lltha4rMz
f96NIwPMz3+8/UrWEocuxhws4jPAqGy5HV/GEgU90ywrAxnAeOc9ME/SEs0m
270/7WDA6mW9iiZzLVE3JyhikzsDJK/0Hi7+y8Jg3/hYCUsGdNzrcznew8J5
Ywu2PVRlAP9N/1/zQhYmXpJQrnunDVcutbsqFrAwsinJs+GtNvQE1d/5fpmF
tkMWt1+1aoODQAk/M4uFf6ntu7/Wa8MGzb2931NYOLc+Ts7usTaM7pGpy4xi
4dntxlqN2dqwUxnSfzBZ2Pt+cFaBjzYUDmycrDJm4Yc9t6tVvbThY4k6O8uQ
hTFP5VbkemiDk4WYBIvBwrDw0LM3udqwMbTtQNZqFuoFygyOsrThx9PgAJY0
C6UCpe2WrNOGXTvSGNndFvjBblhv9A8dko7uTYp7Z4HKVR13BibpkHvdq8e/
3QIfFzTo9v2kQ9u4ZsKmVxZ48GSzW983OujGl72prrRAEyuHNNFeOggUdEaO
XbfARtA60VVHh+QBpTusGAt85KgWUnSBDgXignPX7bZAuyuGJQJZdCBBdpeJ
tEDza38KXNLp8CP6hlAX3wL175Wlzz9DB85cI/au7RbompXpnHaMDoqrPMey
rCzw42PFhrWRdLgalKM1JmeBdSphG3Ts6dBvM953epEF5lJDftds6KC2jnWe
Lm2BI5t3By2zosPF0eHp3WLk+nRDrbQZHc5G6NQLTJtj/0jbWTk9OhyMbfKV
6DXHPs3wlryVdNh8ajpD87o5Bmuu7C8RpMP5cEf7uqvmSNlsF94tQIfXnFzB
kHxz1CzTPW88TQMHOauA4gvmeH1krXDHbxqYZ52ha6eao3bMh6crv9NgY8Ga
ZmaUOao4WEdRPTQQe7hZ2NPYHP1Sjd1nIQ0SmJ4xeobmeP7L0V9a5TQQatzx
Q1bPHK19YkJ9HtFgqie0q4Eyx8GMzqHG+zT4Jnzkrp6GOboH2r57cIsGTU63
fRcvMMfpGjvR/ss0ODsoVtX4zgyt5GfEE4/SQDpcyqCw3QzFprIzx47QIPmf
7O3DbWZoWLz+pUc8DY5ILr+g32SGkbGxstpxNIimM6IKn5nhpN39makYGmw5
6LMyvtAMg3d3NbWG0mDZksdHDKLNcH9d+farbjR46qnl8TqcrPfu5Vp1Vxp4
F+RtDNlphsJzNlzN4dIgl0p+nxlohomJvkU5zjTQsN+2acrdDLcc7Sy+a0uD
DYdmdZcZm6Fl1Qf5tSbkhfPNjM4QM8NPQZ+lLNbQ4ANVJtYkYoZ3cdPx8VU0
OPjfug9+QmbYHV99IE+TBs9FFyed+8dEuSHzprkracBSHfgwMcLEhEObX/eq
kPq4Hjt+p5WJDjU3Fd4tpoFXRWPfxmwmxr5paWoRIuvdGo8RymDi69GAZpxN
nu+i4qK2c0yUcQ8cvSlIg569gWa7TzLJ99mcwycFaOCpI5z/5BATU6V2D3hN
UbC12MDPJoiJUqXN6fSfFLhnF33ZwWDizYjiqYI+CvSPvzqgTWPiwU9PL93r
pUAx5o/83I1MzL3lalL9kYJON5ZV0WomxnwTDPvaQ8HmRX2FP5SZaLt0igfv
KXBLUgiOncNElfFQAdk2Crh7jn0732KKB8T2Pw6tpkD2Wc7ePS9NsSSjRjyn
ioI3Yg/F3etN0SXIdUNrJQWuWUOrllaaolZ736juCwq2oI1f3gNTjGs3BukK
CjyFF/TcumiK9BUy2z4/pCAg9VRzLc8UN/6lC6wopmBV5zXPoiBy/8JWZuhN
CgZVn48c9zfFf1lGzIc3KAi+83O+o7cprh0/GOp8nQLeW47VG44pSn6QDEwq
pCBMWe5Zr74pjpqaGi7LoyCmMLN0ap4pXm9/El2bToFXserldBFTlJVp26hE
bH638CRDyBRjffVvhKZRIFVxnxf+zwT7Mi9+kj9PQX57q8bXERNc5HLcKOIM
BU2i87M6W01wyYalX+xSKFD323u4LNsE28JPHkuIp2BeiFC4a4YJ2l461PP9
MAWjYYneE+dMUG/iZtcW4rJ9aUYbT5rgncTnTVqHKHA4e+f31TgTtLK9EvXp
AAV7XgyHpPmb4C1NUa2gvRQ0qm7lRm80wX+BY7FD4RT8aD4n4rDeBB3uftXZ
SSy7v/n+yjUm+P1V0K7JXSQf75gKb9RNEFMGvecQj5xe3UOTN8H3YifVV+6k
QFL4d8DYjDF+ydlZfSCEAseBU3t5DcbY0/5SNsWXgsizDevMa43xY4pknRpx
OlOkR6nKGC2ELUce7KDg48U9Jg1ojMYmTYc/+ZDzdvMSWVNqjNLlGV3G2ylI
rV138ku6MVr/qOqU8KSgtagm18ffGKtiFWZNulGgJBd255ePMV7teDKTQuwb
t6QyycsYl9Nrdq4mnnQL+ly6mXjz7BterhQsEZm/ao6tMa75PRP9ikvy4+Vw
M0/LGP8VMgfrnCkYXvTmQf8fQO/Wtm5xOwroB2Jr90wCpsS3uZXaUrDv68pO
iZ+AzdqiDHdiyWfRU/RhQP48w6XXbSigQpcYHekGPLHmbpKzNTn/Wo/nK58D
/o6LjythUSAc29fofxxQ8tDIxB1TCjYw97WJHwP04GokBhK7zZXrKo4HXOWi
t2spcdEp6+FfsYBzTsQYHDOhwOlKidjRMHL91ebi7cYUXGjez7rqAjj/NgvV
jShgqClVfFEBjFGVUe3TpcD7y92a48qAlTdF4nOIE284NGspAA41TWh5EXcx
DvXsXgho439ge7cOBYdsh6bnigAe3hen1s2gyPdYWBT7rREq1Gq3D9EpeJV6
LfB1sBHqMusmtDdRkBvCnEnxNULXFQZ3BYnDWe9P2Xga4cXeiaKGjSRP0xKP
nzkbYSTdw8iH2DUgbEGJrhH2ijz9fkqLrG+kU5osaoTx0oLu/9aT/vxa+c8i
1xCb/IdqJ9ZQ8LBqW+rsbEP8yKgRrSZOyvm14sk5QwQ1WlQa8VrXVQ70REP0
sf7Wp08c+ux4jlqYIX5eGjZ9eDUF42lsi1lgiOqxNdPLVlEgYPExpazTACeF
dD9HryR5yHTt+9ZqgMsCNHbYEFPfG7VVGw0w8xFt0TJi/4yHXYlogKKa9fOq
V1DQPHJ6jUeeAbacazRbQpxz3qJ6hmeARyY16qrUKDAdLJphChrgm7CjF8yW
k/4xUnXe/Vcfg2hvfikTR59Oy7/+Ux/PFt/Y+0uF1Ncw3lb2sz7KGGrPLSJe
eGpbxuc6fczO81q+iLhPT1r72Bl9dO7cvmlkKQXxx6N4LzX0MQ2XHn+qRIHy
JmeLqOX62CjHoOcQ3327btlSRX3MlLQUiCP+pNrfzFugj+oHayeYxMwyNk1i
Qg9/VB8LqFWkQPCz1pTNMz18cT+U1alAwV74erTWQw8NgncKL1xC9tNf5R3m
ooeFW7WSf8mT/SZe1lviqIcd29o3vid+17Z5OICph48o/5Z8Yt2QGoe5q/Xw
cQ7dT4/4V1r+YtYvXQyefbUhQI7kY8wz70WqLjqV33/eIUtBg83S4ONJuvhd
dEDzGfGK/PcbOfG6+LksrOAacbvrZuzbrYsXxOlDMcSG5c6ds710cbf4o9Rl
xKJHzaVM1utiVg/HJngRBZnKa/aW1+kgTcDl2cKFpP5Rg6bxL3Rw2E5njgCx
XfOVeXZPdFDjX5z7kAwFsw6pn39fooMXbf9YVRD7flG+PZWmgx7xwuo7iTeU
Sn3R9dfByZrnZS3SFDy3nGTfE9JByfZjHblS5O+VTnVM/mPg+d6PC08Sz/2+
zpMxycCpnK079hLbnfcNevCFga1OW1lc4vb+1wceNjKwYeqlzFzib3GlN56c
Z+DRYq9rYZIUyJXvJDlnYOGPFh3OAjLfT85PFl1B7je/eB6T2GPHVRnLpQys
eFf3bSNxjvgH5VopBqqnBIxKEq/d4kCrn9DG24EDbQ0SFJj8WufdhNrYZpqu
bE0cvPHrw7dsbWzyvjfPeT7pJ+5wZZKdNjY6Zy8xIy7a860ZWNq4a81iHW3i
4YrRz1f0tHG4+sAlBWKe87jM7uXaeCvltPIncdJv4dNB8qN03H+m5NEe4vC7
koqbE+l49LiAWrEYBac7pFZKHKZjz4HWL5eJS6elN1bso+OSOTsfnSMeN1/E
WhVGx/cejUdiiSPfyIf/caVj8kDBHXvi6F/L69NX0NGxnu/9Yx55/+rSYjqf
0pDX11EAxNyJWxKtZTScWcm6SRFvKFl3qf42Df0yrz/XIO7T1Kh8nEfDXqFl
8lLEtvIKkheP0vDAzm7fj3NJ//wSyPVxpOH8osEjR4if3qmvG+6hcPjzZHin
KMnTTsut/e0UWiaCUjNx5NrK0a4WCi84ZDRXEq/Ke7Ko6TmFF2fbby0hTj1d
sq3kCrk+rCF8jNhn1/mxyFByv6LCOD1iw/WL4vkBFELOhX4tYrmhk3L+3hRe
F2lgaxDXeycauLEpNOjIdFpETHPad0SPQWHXWF7LiAh530j8lae0KBx3Hjve
TzxYE1W0ZhWFwQrS7PfE2cY7m5UUKQyJOilQRxz9b3i77CIKl0y97X9K7PQg
cEJCgkL76idv7hOvificICJC4b5onVc3iYW1fBQEBCg8ek+nPZ/4f2/WcsI=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-100, 0},
  PlotLabel->FormBox[
   "\"inactivation time constant for T at 25, 23, and 41 deg C\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.518364385845606*^9, 3.518440033665481*^9, 
  3.518642334303329*^9, 3.518702889305028*^9, 3.549977805037078*^9, 
  3.552325750879982*^9, 3.552326805207568*^9, 3.552396659460788*^9, 
  3.552417195999078*^9, 3.552417249113324*^9, 3.552419092944352*^9, 
  3.552574111445342*^9, 3.552583874673695*^9}]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Set Other Model Parameters and Define IPSC\
\>", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
  3.471719164381555*^9, 3.4717191680331707`*^9}, {3.513452748994402*^9, 
  3.513452753560677*^9}, {3.513460999550459*^9, 3.5134610000206337`*^9}, {
  3.5184309938171797`*^9, 3.518431009064042*^9}}],

Cell[CellGroupData[{

Cell["\<\
Set Parameters, Define Membrane Current Equations\
\>", "Subsection",
 CellChangeTimes->{{3.4876969875518503`*^9, 3.4876970064322357`*^9}, {
  3.4879673071511583`*^9, 3.487967318086102*^9}, {3.488033256697336*^9, 
  3.488033257192277*^9}, {3.517153922878213*^9, 3.517153926789134*^9}, {
  3.517676778217847*^9, 3.517676808002302*^9}, {3.518431094987865*^9, 
  3.518431127764707*^9}, {3.5184395720824966`*^9, 3.5184395878174353`*^9}}],

Cell[TextData[{
 "NOTE: mS/",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["cm", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " * pF = nS"
}], "Text",
 CellChangeTimes->{{3.516621200109408*^9, 3.516621223429027*^9}, {
  3.552572958651835*^9, 3.552572989038903*^9}, {3.552573100273281*^9, 
  3.552573116605815*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"conductance", " ", "parameters"}], ",", " ", "nS"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"gLeak", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxNa", "=", "5000"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxKdr", "=", "500"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxA", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxD", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxK2", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxH", "=", "6.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gMaxT", "=", "30"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.487696758821917*^9, 3.48769683475395*^9}, {
   3.4876971580248413`*^9, 3.487697194458191*^9}, {3.487697227588133*^9, 
   3.487697342025158*^9}, {3.487697773556913*^9, 3.487697823358252*^9}, {
   3.487697935324911*^9, 3.487697953644951*^9}, {3.487697996910564*^9, 
   3.487698031592278*^9}, {3.487698146837307*^9, 3.487698168846258*^9}, {
   3.4876982079064503`*^9, 3.4876982311943607`*^9}, {3.487702751361429*^9, 
   3.4877027610568037`*^9}, {3.487778471200135*^9, 3.487778471526359*^9}, {
   3.487784756974654*^9, 3.487784759451755*^9}, {3.48778569529573*^9, 
   3.487785697309946*^9}, {3.4877857439219923`*^9, 3.487785748320566*^9}, {
   3.48778586650309*^9, 3.487785889774876*^9}, 3.487785956523879*^9, {
   3.4879522306034727`*^9, 3.487952237674926*^9}, {3.4879522940374928`*^9, 
   3.4879522951415462`*^9}, {3.4879586662327213`*^9, 3.48795867367035*^9}, {
   3.487958761482902*^9, 3.487958772090705*^9}, {3.487958911505872*^9, 
   3.4879589230252523`*^9}, {3.4879602822082577`*^9, 3.487960315097665*^9}, {
   3.487960364771529*^9, 3.487960377220252*^9}, {3.487960635712243*^9, 
   3.4879606548730583`*^9}, {3.487961981742197*^9, 3.487962044567758*^9}, {
   3.487962634676701*^9, 3.487962635395265*^9}, {3.487963165356518*^9, 
   3.487963172827118*^9}, {3.487963558126442*^9, 3.487963558228867*^9}, {
   3.4879636377389393`*^9, 3.487963640529179*^9}, 3.487963725310789*^9, {
   3.487963776440998*^9, 3.487963776543344*^9}, {3.487964027379365*^9, 
   3.487964031665745*^9}, {3.487964156577549*^9, 3.4879641566476088`*^9}, {
   3.487965412178969*^9, 3.487965414969306*^9}, 3.4879655141195707`*^9, {
   3.487967100862412*^9, 3.487967120350769*^9}, {3.487967585060948*^9, 
   3.487967585146905*^9}, {3.4879676634806957`*^9, 3.4879676647266483`*^9}, {
   3.487967941005534*^9, 3.487967941091598*^9}, {3.488031082529213*^9, 
   3.4880310925362883`*^9}, {3.4880311598274927`*^9, 3.488031171763468*^9}, {
   3.4880341042413187`*^9, 3.488034104359446*^9}, {3.488034903397388*^9, 
   3.488034903907648*^9}, 3.488035644527114*^9, {3.488036006463282*^9, 
   3.488036006533662*^9}, 3.488036050833233*^9, {3.4880368025074863`*^9, 
   3.488036802601817*^9}, {3.488036994348502*^9, 3.488036994906856*^9}, 
   3.488037180741021*^9, {3.5135143909905577`*^9, 3.513514470184051*^9}, 
   3.5135145649171667`*^9, 3.514221954604286*^9, {3.515340660637012*^9, 
   3.515340675132388*^9}, {3.5153407365856457`*^9, 3.51534074203371*^9}, 
   3.515341144827615*^9, {3.515515024150444*^9, 3.5155150311077833`*^9}, {
   3.515515171602633*^9, 3.515515172314184*^9}, {3.5155152211642437`*^9, 
   3.5155152325405703`*^9}, {3.515515401148755*^9, 3.5155154086679688`*^9}, 
   3.515516703716571*^9, {3.5155172384674177`*^9, 3.515517238874217*^9}, {
   3.515518070256482*^9, 3.515518070501666*^9}, {3.515518434127269*^9, 
   3.51551843428481*^9}, {3.5155190268635387`*^9, 3.515519079624811*^9}, {
   3.51551912289153*^9, 3.515519123362878*^9}, {3.5155192662894897`*^9, 
   3.5155192665763493`*^9}, {3.515519602983859*^9, 3.515519603126788*^9}, {
   3.515519837641821*^9, 3.5155198383768682`*^9}, {3.515521917491351*^9, 
   3.515521920650449*^9}, {3.515522549645958*^9, 3.515522550004446*^9}, {
   3.515606798901681*^9, 3.5156068061180763`*^9}, {3.51560770015156*^9, 
   3.515607700515867*^9}, {3.5163590370813847`*^9, 3.5163590423644753`*^9}, {
   3.516360028563994*^9, 3.5163600419253407`*^9}, {3.516360663856505*^9, 
   3.516360696326827*^9}, {3.516360874638467*^9, 3.516360875054294*^9}, 
   3.516361250993125*^9, {3.5163696468232117`*^9, 3.516369646902022*^9}, {
   3.516369743404002*^9, 3.516369743522139*^9}, {3.5163701100187473`*^9, 
   3.5163701101462193`*^9}, 3.516370208054555*^9, 3.5163721285851927`*^9, {
   3.516618966792757*^9, 3.516618982321686*^9}, {3.5166190840935593`*^9, 
   3.516619084940853*^9}, {3.516621395981357*^9, 3.516621474272853*^9}, 
   3.516621539955926*^9, {3.516622580071151*^9, 3.516622582638933*^9}, {
   3.5166226246409693`*^9, 3.516622626272863*^9}, {3.516622665867044*^9, 
   3.516622669883079*^9}, {3.516622737734417*^9, 3.516622754718422*^9}, 
   3.516622800392764*^9, 3.516622862634707*^9, 3.516622993248356*^9, 
   3.51662315453636*^9, {3.516623799570064*^9, 3.516623816865966*^9}, 
   3.517149710209239*^9, {3.517149792371913*^9, 3.517149792611147*^9}, 
   3.517150211581026*^9, {3.517150249063134*^9, 3.517150254086808*^9}, {
   3.517150301665298*^9, 3.517150312985654*^9}, {3.517152484596034*^9, 
   3.517152486866572*^9}, 3.517153154494814*^9, 3.5171532334501867`*^9, {
   3.517153286084518*^9, 3.517153286611891*^9}, {3.5171533569515457`*^9, 
   3.5171533587353783`*^9}, {3.517153691381714*^9, 3.517153693349468*^9}, {
   3.517153782881337*^9, 3.517153782956716*^9}, {3.5171540416838217`*^9, 
   3.517154041810987*^9}, {3.517319471330464*^9, 3.517319471401577*^9}, 
   3.5173195239567537`*^9, 3.517319572230899*^9, 3.51731960868069*^9, {
   3.517319647674326*^9, 3.51731965660185*^9}, 3.517319821464971*^9, {
   3.517319894756262*^9, 3.5173198986916103`*^9}, 3.517319995385503*^9, {
   3.517320676108296*^9, 3.517320676235866*^9}, {3.517675973315372*^9, 
   3.51767597370569*^9}, {3.517680180305346*^9, 3.517680184414421*^9}, 
   3.517682815027555*^9, {3.517683048220305*^9, 3.517683048682983*^9}, 
   3.517683083725559*^9, {3.5176850426299458`*^9, 3.517685055686771*^9}, 
   3.517685115993045*^9, 3.517685219845358*^9, {3.5176852614071074`*^9, 
   3.517685261958599*^9}, {3.517685536906129*^9, 3.517685537009398*^9}, {
   3.5176855809323883`*^9, 3.517685581091963*^9}, 3.517685663031643*^9, {
   3.5176860755214243`*^9, 3.517686104729129*^9}, {3.5176861396832037`*^9, 
   3.517686140690591*^9}, {3.5177448711508217`*^9, 3.517744871221897*^9}, {
   3.5177563415487833`*^9, 3.5177563430111723`*^9}, 3.51775640474242*^9, {
   3.517756444495769*^9, 3.51775645021632*^9}, {3.5177565074264507`*^9, 
   3.5177565075617437`*^9}, 3.5177599501509953`*^9, 3.51775999347361*^9, {
   3.5177615361997023`*^9, 3.517761536575616*^9}, 3.5177615734895077`*^9, {
   3.517761998315082*^9, 3.5177620282921677`*^9}, 3.517762073710285*^9, {
   3.517762167929809*^9, 3.517762168009096*^9}, {3.517762211275344*^9, 
   3.517762211946884*^9}, {3.517774612280859*^9, 3.517774619135866*^9}, {
   3.5177748469289207`*^9, 3.517774847136427*^9}, 3.517775016176784*^9, {
   3.517775837577323*^9, 3.5177758376484537`*^9}, {3.517778802018902*^9, 
   3.517778805026352*^9}, {3.5177790878471193`*^9, 3.517779088037983*^9}, {
   3.517779372922151*^9, 3.5177793730015993`*^9}, {3.517779406635413*^9, 
   3.5177794067708178`*^9}, 3.51777944642131*^9, {3.5178327560477047`*^9, 
   3.517832756229681*^9}, {3.517832806872336*^9, 3.517832832456635*^9}, 
   3.517832944158269*^9, {3.517833505199119*^9, 3.51783350540421*^9}, {
   3.517833535535568*^9, 3.517833535749456*^9}, {3.517834757808095*^9, 
   3.517834761727344*^9}, 3.5178354367330627`*^9, {3.517835615933069*^9, 
   3.517835616010427*^9}, 3.5178368284845247`*^9, {3.517836859469838*^9, 
   3.5178368658531313`*^9}, {3.517836946025011*^9, 3.5178369471689997`*^9}, {
   3.517836996491288*^9, 3.517836996602404*^9}, {3.5178398493758783`*^9, 
   3.517839853023*^9}, {3.5178399252507753`*^9, 3.517839927986347*^9}, {
   3.517840283377515*^9, 3.5178402834968977`*^9}, 3.517840382565579*^9, {
   3.5178406107443943`*^9, 3.5178406339122963`*^9}, {3.517840699114622*^9, 
   3.5178406992501497`*^9}, {3.51784083454429*^9, 3.517840888922078*^9}, {
   3.517841170037648*^9, 3.517841170852891*^9}, {3.5178413459190073`*^9, 
   3.517841346004397*^9}, {3.5178415037003603`*^9, 3.517841505634947*^9}, {
   3.517841623776558*^9, 3.517841631712566*^9}, {3.517841777526697*^9, 
   3.517841804383225*^9}, {3.517924997706896*^9, 3.517924997792007*^9}, {
   3.5179277197271852`*^9, 3.5179277224228973`*^9}, {3.517927837676091*^9, 
   3.517927840468017*^9}, {3.517927902710636*^9, 3.517927902813985*^9}, 
   3.517929422204517*^9, {3.517935229225078*^9, 3.51793522930545*^9}, {
   3.517935417527851*^9, 3.517935419415687*^9}, {3.517935696987212*^9, 
   3.5179356970904922`*^9}, {3.517935735788765*^9, 3.517935739955962*^9}, 
   3.517935848401409*^9, {3.518107741057488*^9, 3.5181077417355347`*^9}, {
   3.5184401851163273`*^9, 3.518440189410635*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ionic", " ", "driving", " ", "forces"}], ",", " ", "mV"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"eNa", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eK", "=", 
     RowBox[{"-", "100"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eCa", "=", "100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eLeak", "=", 
     RowBox[{"-", "60"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eH", "=", 
     RowBox[{"-", "40"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eGlut", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eGaba", "=", 
     RowBox[{"-", "95"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.487696677034481*^9, 3.4876967393171787`*^9}, {
   3.487696839313919*^9, 3.487696840314044*^9}, {3.487696893572358*^9, 
   3.48769693779029*^9}, {3.487697761205719*^9, 3.487697761555348*^9}, {
   3.487962210655979*^9, 3.487962215847539*^9}, {3.487967953164812*^9, 
   3.4879679532143307`*^9}, {3.487968000600008*^9, 3.4879680009669437`*^9}, {
   3.4880312270625753`*^9, 3.488031237798751*^9}, {3.488034860330435*^9, 
   3.4880348604285603`*^9}, {3.488036676661034*^9, 3.488036676732027*^9}, {
   3.513514341924966*^9, 3.513514369539565*^9}, {3.515340549683794*^9, 
   3.5153405532884502`*^9}, {3.5153406487518587`*^9, 3.515340649460449*^9}, {
   3.515343221150918*^9, 3.515343221188725*^9}, {3.515343270694948*^9, 
   3.515343292728393*^9}, {3.515522032038784*^9, 3.515522068240573*^9}, {
   3.515858097895521*^9, 3.515858110334302*^9}, 3.51637023192734*^9, {
   3.5166189158941793`*^9, 3.51661891613371*^9}, 3.5175785550577908`*^9, {
   3.5176764147733183`*^9, 3.517676415091586*^9}, {3.517685612909251*^9, 
   3.517685613004652*^9}, {3.517774933741469*^9, 3.5177749339716673`*^9}, {
   3.5178368137238083`*^9, 3.517836813843521*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"cell", " ", "capacitance"}], ",", " ", "pF"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"capacitance", "=", "50"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.514062217124867*^9, 3.514062266454339*^9}, {
   3.514062336666883*^9, 3.514062401980044*^9}, {3.5142224737087173`*^9, 
   3.5142224982623*^9}, 3.515245577328597*^9, {3.5166213632540703`*^9, 
   3.516621386956861*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Q10", " ", "values", " ", "for", " ", "peak", " ", "condunctances"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Q10gNa", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gKdr", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gA", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gD", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gK2", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gH", "=", "2.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gT", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Q10gLeak", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tempBase", "=", "25"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.517742033683961*^9, 3.5177421115834703`*^9}, {
   3.517742164536463*^9, 3.517742175744515*^9}, 3.5177448606720123`*^9, {
   3.517760031418234*^9, 3.5177600337217073`*^9}, 3.517762255861423*^9, {
   3.517833548598629*^9, 3.5178335588941402`*^9}, 3.51783689032666*^9, {
   3.518292190480836*^9, 3.51829220840819*^9}, {3.518292943917718*^9, 
   3.518292952693651*^9}, {3.518294122726054*^9, 3.5182941292928267`*^9}, {
   3.518431072157737*^9, 3.518431077332137*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "temperature", " ", "at", " ", "which", " ", "the", " ", "model", " ", 
    "is", " ", "supposed", " ", "to", " ", "run"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"temp", "=", "25"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QiNa", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempNa", ",", "temp", ",", "Q10iNa"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgNa", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempNa", ",", "temp", ",", "Q10gNa"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaKdr", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempKdr", ",", "temp", ",", "Q10aKdr"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgKdr", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gKdr"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaA", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempA", ",", "temp", ",", "Q10aA"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QiA", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempA", ",", "temp", ",", "Q10iA"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgA", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gA"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaD", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempD", ",", "temp", ",", "Q10aD"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QiD", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempD", ",", "temp", ",", "Q10iD"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgD", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gD"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaK2", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempK2", ",", "temp", ",", "Q10aK2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QiK2", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempK2", ",", "temp", ",", "Q10iK2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgK2", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gK2"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaH", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempH", ",", "temp", ",", "Q10aH"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgH", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gH"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QaT", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "temp", ",", "Q10aT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QiT", "=", 
     RowBox[{"TempAdjust", "[", 
      RowBox[{"tempT", ",", "temp", ",", "Q10iT"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgT", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gT"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QgLeak", "=", 
     RowBox[{
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempBase", ",", "temp", ",", "Q10gLeak"}], "]"}], "^", 
      RowBox[{"-", "1"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.514061322121867*^9, 3.514061338913827*^9}, {
   3.514061934831462*^9, 3.514061935599277*^9}, {3.514062173666041*^9, 
   3.514062211461375*^9}, {3.514062454801127*^9, 3.514062525449741*^9}, {
   3.5140625556824102`*^9, 3.514062572907391*^9}, {3.514221947031486*^9, 
   3.5142219493838453`*^9}, 3.514222420605138*^9, {3.51422267747954*^9, 
   3.514222677813321*^9}, {3.515245259130464*^9, 3.515245259596187*^9}, {
   3.515246126965496*^9, 3.5152461277236443`*^9}, {3.515257289017157*^9, 
   3.515257289615466*^9}, {3.515276889598816*^9, 3.5152768897197313`*^9}, {
   3.515277066278204*^9, 3.515277066837246*^9}, {3.5153405286021*^9, 
   3.51534055985222*^9}, {3.515520723298781*^9, 3.5155207235600643`*^9}, {
   3.515521193438122*^9, 3.515521193532022*^9}, {3.5155222395761423`*^9, 
   3.515522260721929*^9}, {3.515606852600273*^9, 3.515606860857829*^9}, {
   3.517152248330657*^9, 3.517152256506701*^9}, {3.517675993173709*^9, 
   3.517676087570222*^9}, {3.517676316388658*^9, 3.5176764018074102`*^9}, {
   3.517676461171324*^9, 3.517676469044086*^9}, {3.5177422146850567`*^9, 
   3.5177422736576843`*^9}, {3.517742316764161*^9, 3.5177424451339808`*^9}, {
   3.517742480037704*^9, 3.517742593707242*^9}, {3.5177530672464657`*^9, 
   3.517753087774703*^9}, {3.518439633608612*^9, 3.5184396339501038`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"membrane", " ", "current", " ", "equations"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"iNa", "[", 
      RowBox[{"v_", ",", "hNa_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"actInfNa", "[", "v", "]"}], "^", "nNa"}], " ", "hNa", " ", 
      "QgNa", " ", "gMaxNa", 
      RowBox[{"(", 
       RowBox[{"v", "-", "eNa"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iK", "[", 
      RowBox[{
      "v_", ",", "mKdr_", ",", "mA_", ",", "hA_", ",", "mD_", ",", "hD_", ",",
        "mK2_", ",", "hK2_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"mA", "^", "nA"}], " ", "hA", " ", "QgA", " ", "gMaxA"}], 
        "+", 
        RowBox[{
         RowBox[{"mD", "^", "nD"}], " ", "hD", " ", "QgD", " ", "gMaxD"}], 
        "+", 
        RowBox[{
         RowBox[{"mK2", "^", "nK2"}], " ", "hK2", " ", "QgK2", " ", 
         "gMaxK2"}], "+", 
        RowBox[{
         RowBox[{"mKdr", "^", "nKdr"}], " ", "QgKdr", " ", "gMaxKdr"}]}], 
       ")"}], 
      RowBox[{"(", 
       RowBox[{"v", "-", "eK"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iH", "[", 
      RowBox[{"v_", ",", "mH_"}], "]"}], ":=", 
     RowBox[{"mH", " ", "QgH", " ", "gMaxH", 
      RowBox[{"(", 
       RowBox[{"v", "-", "eH"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iCa", "[", 
      RowBox[{"v_", ",", "mT_", ",", "hT_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"mT", "^", "nT"}], " ", "hT", " ", "QgT", " ", "gMaxT", 
      RowBox[{"(", 
       RowBox[{"v", "-", "eCa"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vDot", "[", 
      RowBox[{
      "v_", ",", "iInj_", ",", "gGlut_", ",", "gGaba_", ",", "hNa_", ",", 
       "mKdr_", ",", "mA_", ",", "hA_", ",", "mD_", ",", "hD_", ",", "mK2_", 
       ",", "hK2_", ",", "mH_", ",", "mT_", ",", "hT_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"iInj", "-", 
        RowBox[{"iNa", "[", 
         RowBox[{"v", ",", "hNa"}], "]"}], "-", 
        RowBox[{"iK", "[", 
         RowBox[{
         "v", ",", "mKdr", ",", "mA", ",", "hA", ",", "mD", ",", "hD", ",", 
          "mK2", ",", "hK2"}], "]"}], "-", 
        RowBox[{"iH", "[", 
         RowBox[{"v", ",", "mH"}], "]"}], "-", 
        RowBox[{"iCa", "[", 
         RowBox[{"v", ",", "mT", ",", "hT"}], "]"}], "-", 
        RowBox[{"gGlut", 
         RowBox[{"(", 
          RowBox[{"v", "-", "eGlut"}], ")"}]}], "-", 
        RowBox[{"gGaba", 
         RowBox[{"(", 
          RowBox[{"v", "-", "eGaba"}], ")"}]}], "-", 
        RowBox[{"QgLeak", " ", "gLeak", 
         RowBox[{"(", 
          RowBox[{"v", "-", "eLeak"}], ")"}]}]}], ")"}], "/", 
      "capacitance"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.4880315351067142`*^9, 3.4880315976120453`*^9}, {
   3.488033101410574*^9, 3.4880331239616547`*^9}, {3.488034017282468*^9, 
   3.4880340451634398`*^9}, {3.513524099073435*^9, 3.5135242605589123`*^9}, {
   3.5135242980140667`*^9, 3.513524327342857*^9}, {3.514062983702176*^9, 
   3.514062987678183*^9}, 3.5140630228982983`*^9, {3.51422196323356*^9, 
   3.514221974856022*^9}, {3.514222551898706*^9, 3.514222554592469*^9}, {
   3.515340858164073*^9, 3.5153409449393063`*^9}, {3.515521952388606*^9, 
   3.515522023403471*^9}, {3.515522079679173*^9, 3.5155221082316313`*^9}, 
   3.5155238621274548`*^9, {3.515607074319067*^9, 3.515607141954091*^9}, {
   3.51635907789869*^9, 3.5163591289082947`*^9}, {3.516360074820047*^9, 
   3.51636008401976*^9}, {3.516360592625456*^9, 3.516360625338482*^9}, {
   3.517152304298143*^9, 3.5171523146182623`*^9}, {3.517152344620451*^9, 
   3.517152409206658*^9}, {3.517676503216976*^9, 3.517676531400364*^9}, {
   3.517676571634849*^9, 3.5176765754420958`*^9}, {3.517676642197727*^9, 
   3.517676673093177*^9}, {3.51767674060284*^9, 3.5176767654822893`*^9}, {
   3.517677363643642*^9, 3.517677393836838*^9}, {3.517677557660946*^9, 
   3.517677560674382*^9}, {3.517742832541246*^9, 3.5177429018634567`*^9}, {
   3.5177524501340437`*^9, 3.517752467588574*^9}, {3.517753056677264*^9, 
   3.517753056908313*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Define IPSC", "Subsection",
 CellChangeTimes->{{3.5143160798198547`*^9, 3.514316084051895*^9}, {
   3.514316200546558*^9, 3.514316201512967*^9}, {3.515341478145273*^9, 
   3.515341507542569*^9}, {3.515844443639246*^9, 3.5158444490687513`*^9}, {
   3.515866871569363*^9, 3.5158668797357807`*^9}, {3.5171696536759377`*^9, 
   3.517169692626734*^9}, {3.5171705149985437`*^9, 3.517170516285997*^9}, 
   3.51801066020887*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tauRiseBase", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tauDecayBase", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gGabaBase", "=", "12"}], ";"}], "                             ", 
  RowBox[{"(*", " ", 
   RowBox[{"peak", " ", "unitary", " ", "IPSC", " ", "conductance"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gMaxGabaBase", "=", 
    RowBox[{"gGabaBase", "+", "3"}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"maximum", " ", "possible", " ", "GABA", " ", "conductance"}], " ",
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tempGaba", "=", "25"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10rGaba", "=", "2.1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Q10", " ", "for", " ", "GABA", " ", "rise", " ", "kinetics"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10dGaba", "=", "2.1"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Q10", " ", "for", " ", "GABA", " ", "decay", " ", "kinetics"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Q10gGaba", "=", "1.5"}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Q10", " ", "for", " ", "GABA", " ", "conductance"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tauRise", "=", 
   RowBox[{
    RowBox[{"TempAdjust", "[", 
     RowBox[{"tempGaba", ",", "temp", ",", "Q10rGaba"}], "]"}], " ", 
    "tauRiseBase"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tauDecay", "=", 
   RowBox[{
    RowBox[{"TempAdjust", "[", 
     RowBox[{"tempGaba", ",", "temp", ",", "Q10dGaba"}], "]"}], " ", 
    "tauDecayBase"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gUnitaryGaba", "=", 
   RowBox[{"gGabaBase", "/", 
    RowBox[{"TempAdjust", "[", 
     RowBox[{"tempGaba", ",", "temp", ",", "Q10gGaba"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gMaxGaba", "=", 
   RowBox[{"gMaxGabaBase", "/", 
    RowBox[{"TempAdjust", "[", 
     RowBox[{"tempGaba", ",", "temp", ",", "Q10gGaba"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gabaPeakTime", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "/", "tauDecay"}], "]"}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"tauRise", "+", "tauDecay"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"tauRise", " ", "tauDecay"}], ")"}]}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "tauDecay"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"tauRise", "+", "tauDecay"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"tauRise", " ", "tauDecay"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gabaNorm", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "gabaPeakTime"}], "/", "tauRise"}], "]"}]}], ")"}], 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "gabaPeakTime"}], "/", "tauDecay"}], "]"}]}], ")"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.517170544368561*^9, 3.517170582583291*^9}, {
   3.517170784015193*^9, 3.517170784101646*^9}, {3.5173344029534483`*^9, 
   3.517334429147019*^9}, {3.517336444535534*^9, 3.5173364447728453`*^9}, {
   3.517689877219516*^9, 3.51768992496313*^9}, {3.5176899854459963`*^9, 
   3.517690218027308*^9}, {3.5176904306656733`*^9, 3.5176904364330482`*^9}, {
   3.51774358628655*^9, 3.517743608201692*^9}, {3.5177436411626472`*^9, 
   3.517743641820188*^9}, {3.5177601424458723`*^9, 3.5177601425239363`*^9}, {
   3.518010113116337*^9, 3.518010113281398*^9}, {3.518010249545745*^9, 
   3.51801045599949*^9}, {3.5180105289717617`*^9, 3.518010615885605*^9}, {
   3.518010647211026*^9, 3.518010647834839*^9}, {3.518010763750074*^9, 
   3.518010767893528*^9}, 3.51801080204091*^9, 3.5180108368952227`*^9, {
   3.518010867881526*^9, 3.518011012943486*^9}, 3.5180111370603733`*^9, {
   3.518015330928549*^9, 3.518015339894644*^9}, {3.5180155461214333`*^9, 
   3.518015546238974*^9}, {3.518015583907288*^9, 3.51801558403314*^9}, {
   3.5180156342208033`*^9, 3.518015634410685*^9}, {3.518107921478078*^9, 
   3.5181079215863*^9}, 3.5182929188806067`*^9, 3.5182945483849287`*^9, {
   3.5184397102116947`*^9, 3.5184397106094646`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Define Procedure for Changing Model Temperature\
\>", "Subsection",
 CellChangeTimes->{{3.4876969875518503`*^9, 3.4876970064322357`*^9}, {
  3.4879673071511583`*^9, 3.487967318086102*^9}, {3.488033256697336*^9, 
  3.488033257192277*^9}, {3.517680883499103*^9, 3.5176808862016287`*^9}, {
  3.517756052375125*^9, 3.517756099327902*^9}, {3.5180125147219267`*^9, 
  3.518012528399995*^9}}],

Cell["\<\
SetTemperature adjusts all model parameters to make them conform to the \
selected temperature.  It also computes the resting state given those \
adjustments.  If given a second argument True, it prints out a brief report \
of model properties at that temperature.\
\>", "Text",
 CellChangeTimes->{{3.552574203630974*^9, 3.5525742777533216`*^9}, {
  3.5525743174677563`*^9, 3.552574365075832*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetTemperature", "[", 
   RowBox[{"temp_", ",", 
    RowBox[{"print_:", "False"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"vTraj", ",", "tf", ",", "s", ",", "times", ",", "rest"}], "}"}],
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"QiNa", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempNa", ",", "temp", ",", "Q10iNa"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgNa", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gNa"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaKdr", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempKdr", ",", "temp", ",", "Q10aKdr"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgKdr", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gKdr"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaA", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempA", ",", "temp", ",", "Q10aA"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QiA", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempA", ",", "temp", ",", "Q10iA"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgA", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gA"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaD", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempD", ",", "temp", ",", "Q10aD"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QiD", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempD", ",", "temp", ",", "Q10iD"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgD", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gD"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaK2", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempK2", ",", "temp", ",", "Q10aK2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QiK2", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempK2", ",", "temp", ",", "Q10iK2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgK2", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gK2"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaH", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempH", ",", "temp", ",", "Q10aH"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgH", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gH"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QaT", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempT", ",", "temp", ",", "Q10aT"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QiT", "=", 
      RowBox[{"TempAdjust", "[", 
       RowBox[{"tempT", ",", "temp", ",", "Q10iT"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"QgT", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gT"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"QgLeak", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempBase", ",", "temp", ",", "Q10gLeak"}], "]"}], "^", 
       RowBox[{"-", "1"}]}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"compute", " ", "GABA", " ", "PSC", " ", "waveform"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"tauRise", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempGaba", ",", "temp", ",", "Q10rGaba"}], "]"}], " ", 
       "tauRiseBase"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tauDecay", "=", 
      RowBox[{
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempGaba", ",", "temp", ",", "Q10dGaba"}], "]"}], " ", 
       "tauDecayBase"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"gUnitaryGaba", "=", 
      RowBox[{"gGabaBase", "/", 
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempGaba", ",", "temp", ",", "Q10gGaba"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gMaxGaba", "=", 
      RowBox[{"gMaxGabaBase", "/", 
       RowBox[{"TempAdjust", "[", 
        RowBox[{"tempGaba", ",", "temp", ",", "Q10gGaba"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gabaPeakTime", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "/", "tauDecay"}], "]"}], "-", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"tauRise", "+", "tauDecay"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"tauRise", " ", "tauDecay"}], ")"}]}], "]"}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "tauDecay"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"tauRise", "+", "tauDecay"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"tauRise", " ", "tauDecay"}], ")"}]}]}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gabaNorm", "=", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "gabaPeakTime"}], "/", "tauRise"}], "]"}]}], ")"}], 
         
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "gabaPeakTime"}], "/", "tauDecay"}], "]"}]}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gabaPsc", "[", 
       RowBox[{"t_", ",", "tStim_"}], "]"}], ":=", 
      RowBox[{"Piecewise", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"t", "<", "tStim"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"gabaNorm", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"t", "-", "tStim"}], ")"}]}], "/", "tauRise"}], 
               "]"}]}], ")"}], 
            RowBox[{"Exp", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"t", "-", "tStim"}], ")"}]}], "/", "tauDecay"}], 
             "]"}]}], ",", 
           RowBox[{"t", "\[GreaterEqual]", "tStim"}]}], "}"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"compute", " ", "resting", " ", "state"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"diffEq", "=", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"v", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"vDot", "[", 
          RowBox[{
           RowBox[{"v", "[", "t", "]"}], ",", "0", ",", "0", ",", "0", ",", 
           RowBox[{"hNa", "[", "t", "]"}], ",", 
           RowBox[{"mKdr", "[", "t", "]"}], ",", 
           RowBox[{"mA", "[", "t", "]"}], ",", 
           RowBox[{"hA", "[", "t", "]"}], ",", 
           RowBox[{"mD", "[", "t", "]"}], ",", 
           RowBox[{"hD", "[", "t", "]"}], ",", 
           RowBox[{"mK2", "[", "t", "]"}], ",", 
           RowBox[{"hK2", "[", "t", "]"}], ",", 
           RowBox[{"mH", "[", "t", "]"}], ",", 
           RowBox[{"mT", "[", "t", "]"}], ",", 
           RowBox[{"hT", "[", "t", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hNa", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hNa", "[", "t", "]"}], ",", 
           RowBox[{"inactInfNa", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiNa", " ", 
            RowBox[{"inactTauNa", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mKdr", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mKdr", "[", "t", "]"}], ",", 
           RowBox[{"actInfKdr", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaKdr", " ", 
            RowBox[{"actTauKdr", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mA", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mA", "[", "t", "]"}], ",", 
           RowBox[{"actInfA", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaA", " ", 
            RowBox[{"actTauA", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hA", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hA", "[", "t", "]"}], ",", 
           RowBox[{"inactInfA", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiA", " ", 
            RowBox[{"inactTauA", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mD", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mD", "[", "t", "]"}], ",", 
           RowBox[{"actInfD", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaD", " ", 
            RowBox[{"actTauD", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hD", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hD", "[", "t", "]"}], ",", 
           RowBox[{"inactInfD", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiD", " ", 
            RowBox[{"inactTauD", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mK2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mK2", "[", "t", "]"}], ",", 
           RowBox[{"actInfK2", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaK2", " ", 
            RowBox[{"actTauK2", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hK2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hK2", "[", "t", "]"}], ",", 
           RowBox[{"inactInfK2", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiK2", " ", 
            RowBox[{"inactTauK2", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mH", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mH", "[", "t", "]"}], ",", 
           RowBox[{"actInfH", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaH", " ", 
            RowBox[{"actTauH", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mT", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mT", "[", "t", "]"}], ",", 
           RowBox[{"actInfT", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaT", " ", 
            RowBox[{"actTauT", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hT", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hT", "[", "t", "]"}], ",", 
           RowBox[{"inactInfT", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiT", " ", 
            RowBox[{"inactTauT", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"v0", "=", 
      RowBox[{"-", "60"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"initCond", "=", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hNa", "[", "0", "]"}], "==", 
         RowBox[{"inactInfNa", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mKdr", "[", "0", "]"}], "==", 
         RowBox[{"actInfKdr", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"mA", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"actInfA", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hA", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"inactInfA", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"mD", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"actInfD", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hD", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"inactInfD", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"mK2", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"actInfK2", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hK2", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"inactInfK2", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mH", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"actInfH", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mT", "[", "0", "]"}], "==", 
         RowBox[{"actInfT", "[", "v0", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hT", "[", "0", "]"}], "\[Equal]", 
         RowBox[{"inactInfT", "[", "v0", "]"}]}]}], "\[IndentingNewLine]", 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eqn", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"diffEq", ",", "initCond"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tf", "=", "50000"}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"eqn", ",", 
        RowBox[{"{", 
         RowBox[{
         "v", ",", "hNa", ",", "mKdr", ",", "mA", ",", "hA", ",", "mD", ",", 
          "hD", ",", "mK2", ",", "hK2", ",", "mH", ",", "mT", ",", "hT"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tf"}], "}"}], ",", 
        RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"v0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"v", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"hNa0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"hNa", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mKdr0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mKdr", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mD0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mD", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"hD0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"hD", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mA0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mA", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"hA0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"hA", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mK20", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mK2", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"hK20", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"hK2", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mH0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mH", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mT0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"mT", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"hT0", "=", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"hT", "[", "tf", "]"}], "/.", "s"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"initCond", "=", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"v", "[", "0", "]"}], "\[Equal]", "v0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hNa", "[", "0", "]"}], "==", "hNa0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mKdr", "[", "0", "]"}], "==", "mKdr0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mD", "[", "0", "]"}], "==", "mD0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hD", "[", "0", "]"}], "==", "hD0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mA", "[", "0", "]"}], "==", "mA0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hA", "[", "0", "]"}], "==", "hA0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mK2", "[", "0", "]"}], "==", "mK20"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hK2", "[", "0", "]"}], "==", "hK20"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mH", "[", "0", "]"}], "\[Equal]", "mH0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"mT", "[", "0", "]"}], "\[Equal]", "mT0"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"hT", "[", "0", "]"}], "\[Equal]", "hT0"}]}], 
       "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"times", "=", 
      RowBox[{"Table", "[", 
       RowBox[{"t", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"tf", "-", "1000"}], ",", "tf", ",", "0.1"}], "}"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vTraj", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"times", ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{"v", "[", "#", "]"}], "/.", "s"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "times"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{
          RowBox[{"FindSpikes", "[", "vTraj", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"rest", "=", 
        RowBox[{"\"\<resting potential: \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Round", "[", 
           RowBox[{"v0", ",", "0.1"}], "]"}], "]"}], "<>", "\"\< mV\>\""}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"rest", "=", "\"\<Model is autonomously active!\>\""}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", "rest", "]"}]}]}], "\[IndentingNewLine]", "]"}],
      ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"print", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "rest", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<IPSC properties at \>\"", ",", "temp", ",", "\"\< deg:\\n\>\"", 
          ",", 
          RowBox[{"Round", "[", 
           RowBox[{"tauRise", ",", "0.1"}], "]"}], ",", 
          "\"\< ms rise tau, \>\"", ",", 
          RowBox[{"Round", "[", 
           RowBox[{"tauDecay", ",", "0.1"}], "]"}], ",", 
          "\"\< ms decay tau\\n\>\"", ",", 
          RowBox[{"Round", "[", 
           RowBox[{"gUnitaryGaba", ",", "0.1"}], "]"}], ",", 
          "\"\< nS peak unitary conductance\>\""}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5180112856664457`*^9, 3.5180112941694117`*^9}, {
   3.51801228662633*^9, 3.5180122884660378`*^9}, {3.5180123454135303`*^9, 
   3.5180123757170963`*^9}, {3.518012414545115*^9, 3.5180124322334003`*^9}, {
   3.5180125789882*^9, 3.518012625469249*^9}, {3.5180127014394703`*^9, 
   3.51801275364861*^9}, {3.518013141325759*^9, 3.518013325073324*^9}, {
   3.5180133577633553`*^9, 3.518013581991034*^9}, 3.5181157526171103`*^9, {
   3.552574195311553*^9, 3.55257419699219*^9}, {3.552576040739979*^9, 
   3.5525760486367407`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["DLM at 25\[Degree]C", "Section",
 CellChangeTimes->{{3.4717188259114237`*^9, 3.471718830499755*^9}, {
   3.471719164381555*^9, 3.4717191680331707`*^9}, {3.4717803802459593`*^9, 
   3.471780382889163*^9}, {3.471780468671698*^9, 3.471780470716402*^9}, {
   3.4875971191162043`*^9, 3.487597130572259*^9}, {3.488030936160829*^9, 
   3.48803098419333*^9}, {3.515866855089326*^9, 3.515866859367106*^9}, {
   3.51717044085185*^9, 3.517170477379496*^9}, {3.517689815026187*^9, 
   3.5176898442811832`*^9}, {3.517689941221985*^9, 3.5176899418298397`*^9}, {
   3.517693669873197*^9, 3.5176937073763313`*^9}, {3.517845436267386*^9, 
   3.517845442082622*^9}, {3.517845493300589*^9, 3.517845502149212*^9}, {
   3.549977834423938*^9, 3.549977852260335*^9}, {3.549979799994926*^9, 
   3.549979822191259*^9}, {3.549979958497123*^9, 3.549979965352028*^9}, 
   3.549980112671854*^9, {3.5523966783107443`*^9, 3.552396678951071*^9}, {
   3.552419064462193*^9, 3.5524190679965763`*^9}, {3.552419977295068*^9, 
   3.552419998757758*^9}, {3.552487646229402*^9, 3.552487647628454*^9}, {
   3.552575613971031*^9, 3.5525756222635317`*^9}, {3.552575670092305*^9, 
   3.552575694894166*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetTemperature", "[", 
  RowBox[{"25", ",", "True"}], "]"}]], "Input",
 CellChangeTimes->{{3.5525758999125137`*^9, 3.552575906132925*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"resting potential: -57.2 mV\"\>"], "Print",
 CellChangeTimes->{3.552575906970912*^9, 3.552576058256905*^9, 
  3.552583874986155*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IPSC properties at \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\" deg:\\n\"\>", "\[InvisibleSpace]", 
   "0.7000000000000001`", "\[InvisibleSpace]", "\<\" ms rise tau, \"\>", 
   "\[InvisibleSpace]", "10.`", 
   "\[InvisibleSpace]", "\<\" ms decay tau\\n\"\>", "\[InvisibleSpace]", 
   "12.`", "\[InvisibleSpace]", "\<\" nS peak unitary conductance\"\>"}],
  SequenceForm[
  "IPSC properties at ", 25, " deg:\n", 0.7000000000000001, " ms rise tau, ", 
   10., " ms decay tau\n", 12., " nS peak unitary conductance"],
  Editable->False]], "Print",
 CellChangeTimes->{3.552575906970912*^9, 3.552576058256905*^9, 
  3.552583874991949*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series of Current Pulses", "Subsection",
 CellChangeTimes->{{3.552575953103868*^9, 3.552575962749138*^9}}],

Cell[CellGroupData[{

Cell["Specify Current Injection", "Subsubsection",
 CellChangeTimes->{{3.552576468318166*^9, 3.5525764906839247`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dcLevel", "=", "0"}], ";", " ", 
  RowBox[{"(*", " ", "pA", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"tStep", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tDur", "=", "2000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tPost", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pulseSize", "=", 
  RowBox[{"Table", "[", 
   RowBox[{"i", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50", ",", 
      RowBox[{"-", "110"}], ",", 
      RowBox[{"-", "20"}]}], "}"}]}], "]"}], " ", 
  RowBox[{"(*", " ", "pA", " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.55257643275635*^9, 3.552576449025181*^9}, {
  3.5525766573188353`*^9, 3.552576657414029*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"50", ",", "30", ",", "10", ",", 
   RowBox[{"-", "10"}], ",", 
   RowBox[{"-", "30"}], ",", 
   RowBox[{"-", "50"}], ",", 
   RowBox[{"-", "70"}], ",", 
   RowBox[{"-", "90"}], ",", 
   RowBox[{"-", "110"}]}], "}"}]], "Output",
 CellChangeTimes->{3.552576529458055*^9, 3.55257665886138*^9, 
  3.5525838750483837`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Simulate", "Subsubsection",
 CellChangeTimes->{{3.552576468318166*^9, 3.552576510619452*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tf", "=", 
   RowBox[{"tStep", "+", "tDur", "+", "tPost"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showTimes", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tf", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vShow", "=", 
    RowBox[{"Range", "[", 
     RowBox[{"Length", "[", "pulseSize", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ampl", "=", 
      RowBox[{"pulseSize", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"iInj", "[", "t_", "]"}], ":=", 
      RowBox[{
       RowBox[{"ampl", " ", 
        RowBox[{"UnitBox", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "tStep", "-", 
            RowBox[{"tDur", "/", "2"}]}], ")"}], "/", "tDur"}], "]"}]}], "+", 
       "dcLevel"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"diffEq", "=", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"v", "'"}], "[", "t", "]"}], "==", 
         RowBox[{"vDot", "[", 
          RowBox[{
           RowBox[{"v", "[", "t", "]"}], ",", 
           RowBox[{"iInj", "[", "t", "]"}], ",", "0", ",", "0", ",", 
           RowBox[{"hNa", "[", "t", "]"}], ",", 
           RowBox[{"mKdr", "[", "t", "]"}], ",", 
           RowBox[{"mA", "[", "t", "]"}], ",", 
           RowBox[{"hA", "[", "t", "]"}], ",", 
           RowBox[{"mD", "[", "t", "]"}], ",", 
           RowBox[{"hD", "[", "t", "]"}], ",", 
           RowBox[{"mK2", "[", "t", "]"}], ",", 
           RowBox[{"hK2", "[", "t", "]"}], ",", 
           RowBox[{"mH", "[", "t", "]"}], ",", 
           RowBox[{"mT", "[", "t", "]"}], ",", 
           RowBox[{"hT", "[", "t", "]"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hNa", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hNa", "[", "t", "]"}], ",", 
           RowBox[{"inactInfNa", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiNa", " ", 
            RowBox[{"inactTauNa", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mKdr", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mKdr", "[", "t", "]"}], ",", 
           RowBox[{"actInfKdr", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaKdr", " ", 
            RowBox[{"actTauKdr", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mA", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mA", "[", "t", "]"}], ",", 
           RowBox[{"actInfA", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaA", " ", 
            RowBox[{"actTauA", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hA", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hA", "[", "t", "]"}], ",", 
           RowBox[{"inactInfA", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiA", " ", 
            RowBox[{"inactTauA", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mD", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mD", "[", "t", "]"}], ",", 
           RowBox[{"actInfD", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaD", " ", 
            RowBox[{"actTauD", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hD", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hD", "[", "t", "]"}], ",", 
           RowBox[{"inactInfD", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiD", " ", 
            RowBox[{"inactTauD", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mK2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mK2", "[", "t", "]"}], ",", 
           RowBox[{"actInfK2", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaK2", " ", 
            RowBox[{"actTauK2", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hK2", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hK2", "[", "t", "]"}], ",", 
           RowBox[{"inactInfK2", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiK2", " ", 
            RowBox[{"inactTauK2", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mH", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mH", "[", "t", "]"}], ",", 
           RowBox[{"actInfH", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaH", " ", 
            RowBox[{"actTauH", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"mT", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"mT", "[", "t", "]"}], ",", 
           RowBox[{"actInfT", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QaT", " ", 
            RowBox[{"actTauT", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"hT", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"xDot", "[", 
          RowBox[{
           RowBox[{"hT", "[", "t", "]"}], ",", 
           RowBox[{"inactInfT", "[", 
            RowBox[{"v", "[", "t", "]"}], "]"}], ",", 
           RowBox[{"QiT", " ", 
            RowBox[{"inactTauT", "[", 
             RowBox[{"v", "[", "t", "]"}], "]"}]}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"eqn", "=", 
      RowBox[{"Join", "[", 
       RowBox[{"diffEq", ",", "initCond"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"eqn", ",", 
        RowBox[{"{", 
         RowBox[{
         "v", ",", "hNa", ",", "mKdr", ",", "mA", ",", "hA", ",", "mD", ",", 
          "hD", ",", "mK2", ",", "hK2", ",", "mH", ",", "mT", ",", "hT"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tf"}], "}"}], ",", 
        RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"vShow", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"showTimes", ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{
              RowBox[{"v", "[", "#", "]"}], "/.", "s"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "&"}], "/@", "showTimes"}]}], 
        "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<completed pulse \>\"", ",", "i"}], "]"}]}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "pulseSize", "]"}]}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5143162199320717`*^9, 3.5143162480927057`*^9}, {
   3.514316280445656*^9, 3.5143162859818773`*^9}, {3.514316558448783*^9, 
   3.5143166218529367`*^9}, {3.5143166554395113`*^9, 3.51431667142336*^9}, {
   3.514316703273817*^9, 3.5143167036243267`*^9}, {3.514316762363852*^9, 
   3.5143167627150803`*^9}, {3.51431687761688*^9, 3.514316880512229*^9}, {
   3.514317430033224*^9, 3.514317492076048*^9}, {3.5143176645906076`*^9, 
   3.51431766529924*^9}, {3.515245688771372*^9, 3.515245693526033*^9}, {
   3.515245888849163*^9, 3.515245901528607*^9}, {3.5152768788390512`*^9, 
   3.5152768790755053`*^9}, {3.515277000545651*^9, 3.515277034094742*^9}, {
   3.5152771362897043`*^9, 3.515277145553042*^9}, {3.515277975688547*^9, 
   3.51527797997115*^9}, {3.515278436548134*^9, 3.515278436618506*^9}, {
   3.515278709554515*^9, 3.515278745624268*^9}, {3.515278891889616*^9, 
   3.515278905940221*^9}, {3.515344172684794*^9, 3.515344181137985*^9}, {
   3.5155159073742647`*^9, 3.5155159084193907`*^9}, {3.515520574933424*^9, 
   3.515520575379759*^9}, {3.51552092787535*^9, 3.515520935739271*^9}, {
   3.515521245600708*^9, 3.5155212524086657`*^9}, {3.516369917173389*^9, 
   3.516369927061324*^9}, {3.5166224705740957`*^9, 3.5166224765095367`*^9}, {
   3.516622690326768*^9, 3.516622696376281*^9}, {3.516623344116988*^9, 
   3.51662339337236*^9}, {3.5166234320387783`*^9, 3.516623437967039*^9}, {
   3.516623543154211*^9, 3.516623589762689*^9}, {3.516623699656406*^9, 
   3.516623700118808*^9}, {3.516623914473761*^9, 3.516623914633081*^9}, {
   3.517149869946003*^9, 3.517149875537507*^9}, {3.517150641156467*^9, 
   3.517150655209826*^9}, {3.517150796208111*^9, 3.517150796519651*^9}, {
   3.517677998448752*^9, 3.517678008224382*^9}, {3.517678043178166*^9, 
   3.517678099357154*^9}, {3.5176781646593447`*^9, 3.51767819150941*^9}, {
   3.5176782223564463`*^9, 3.51767822293577*^9}, 3.517678647905073*^9, 
   3.517684031576391*^9, {3.517684229550577*^9, 3.517684232925992*^9}, {
   3.517685421689934*^9, 3.517685421839593*^9}, {3.517925130638763*^9, 
   3.517925137902647*^9}, {3.5179271645278*^9, 3.5179271735894547`*^9}, {
   3.517927686158347*^9, 3.517927689394142*^9}, {3.5525761985037737`*^9, 
   3.552576244231126*^9}, {3.552576359695363*^9, 3.552576360000716*^9}, {
   3.552576407178726*^9, 3.552576424399764*^9}, 3.55257657448595*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["completed pulse ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.5525838811993303`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["completed pulse ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583881670806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["completed pulse ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583882122396*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["completed pulse ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583882573585*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["completed pulse ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583883064642*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["completed pulse ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.55258388352115*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "7"}],
  SequenceForm["completed pulse ", 7],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583884230378*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["completed pulse ", 8],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.5525838849932003`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"completed pulse \"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm["completed pulse ", 9],
  Editable->False]], "Print",
 CellChangeTimes->{3.552576262213623*^9, 3.552576547154017*^9, 
  3.552576584093974*^9, 3.552576668255809*^9, 3.552583885850217*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"vShow", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
     RowBox[{"ToString", "[", 
      RowBox[{"pulseSize", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< nA\>\""}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "95"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.552576278543318*^9, 3.552576333774634*^9}, {
  3.552576374197546*^9, 3.552576398198103*^9}}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], LineBox[CompressedData["
1:eJxMuHVY1P3+fW0ntmIriqIoJiAiIJvu7p7usrtbsRO7uwO7E7u7u1ts/X3O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    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -95},
  PlotLabel->FormBox["\"50 nA\"", TraditionalForm],
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.552576290533079*^9, 3.552576335037746*^9, {3.552576393572774*^9, 
   3.552576398728485*^9}, 3.552576557644823*^9, 3.5525766310267477`*^9, 
   3.552576673057673*^9, 3.55258388603684*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"vShow", "[", 
    RowBox[{"[", 
     RowBox[{"3", ";;"}], "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
     RowBox[{"StringDrop", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<, \>\""}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Sort", "[", 
             RowBox[{"pulseSize", "[", 
              RowBox[{"[", 
               RowBox[{"2", ";;"}], "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
        "]"}], ",", 
       RowBox[{"-", "2"}]}], "]"}], "<>", "\"\< nA\>\""}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "105"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "All"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "105"}], ",", "All"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.552576278543318*^9, 3.552576333774634*^9}, {
  3.552576374197546*^9, 3.552576398198103*^9}, {3.552576639229001*^9, 
  3.5525766485674257`*^9}, {3.552576685135931*^9, 3.552576760846978*^9}, {
  3.5525768112680387`*^9, 3.55257681779589*^9}, {3.552576876870112*^9, 
  3.552576887861052*^9}, {3.552576922730225*^9, 3.552576941276269*^9}, {
  3.552576990535892*^9, 3.5525770007673492`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], LineBox[CompressedData["
1:eJxMuHVY1P3+fW0ntmIriqIoJiAiIJvu7p7usrtbsRO7uwO7E7u7u1ts/X3O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